/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;

public class JavaBeanHelper {
    public static void setProperties(Map<String, String> properties, Object object) throws Exception {
        if (properties != null) {
            for (String name : properties.keySet()) {
                JavaBeanHelper.setProperty(object, name, properties.get(name));
            }
        }
    }

    public static void setProperty(Object object, String property, String value) throws Exception {
        Method method = JavaBeanHelper.findMethod(object.getClass(), property);
        if (method == null) {
            throw new Exception(property);
        }
        Class parameterType = JavaBeanHelper.getSetterType(method);
        if (parameterType == null) {
            throw new Exception(property);
        }
        Object[] parameters = new Object[1];
        if (parameterType.equals(Short.TYPE) || parameterType.equals(Short.class)) {
            parameters[0] = new Short(value);
        } else if (parameterType.equals(Integer.TYPE) || parameterType.equals(Integer.class)) {
            parameters[0] = new Integer(value);
        } else if (parameterType.equals(Long.TYPE) || parameterType.equals(Long.class)) {
            parameters[0] = new Long(value);
        } else if (parameterType.equals(String.class)) {
            parameters[0] = value;
        } else if (parameterType.equals(Boolean.TYPE) || parameterType.equals(Boolean.class)) {
            parameters[0] = Boolean.valueOf(value);
        } else if (parameterType.equals(Float.TYPE) || parameterType.equals(Float.class)) {
            parameters[0] = new Float(value);
        } else if (parameterType.equals(Double.TYPE) || parameterType.equals(Double.class)) {
            parameters[0] = new Double(value);
        } else if (parameterType.equals(URL.class)) {
            parameters[0] = new URL(value);
        } else if (parameterType.isArray() && parameterType.getComponentType().equals(Byte.TYPE)) {
            parameters[0] = value.getBytes();
        } else {
            throw new Exception(property);
        }
        method.invoke(object, parameters);
    }

    public static Method findMethod(Class clazz, String property) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(JavaBeanHelper.setterName(property)) || !JavaBeanHelper.hasSupportedArgumentType(method)) continue;
            return method;
        }
        return null;
    }

    private static boolean hasSupportedArgumentType(Method method) {
        Class parameterType = JavaBeanHelper.getSetterType(method);
        return parameterType.equals(Short.TYPE) || parameterType.equals(Short.class) || parameterType.equals(Integer.TYPE) || parameterType.equals(Integer.class) || parameterType.equals(Long.TYPE) || parameterType.equals(Long.class) || parameterType.equals(String.class) || parameterType.equals(Boolean.TYPE) || parameterType.equals(Boolean.class) || parameterType.equals(Float.TYPE) || parameterType.equals(Float.class) || parameterType.equals(Double.TYPE) || parameterType.equals(Double.class) || parameterType.equals(URL.class) || parameterType.isArray() && parameterType.getComponentType().equals(Byte.TYPE);
    }

    public static String setterName(String property) {
        String firstCharacter = property.substring(0, 1);
        return "set" + firstCharacter.toUpperCase() + property.substring(1);
    }

    public static Class getSetterType(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            return parameterTypes[0];
        }
        return null;
    }
}

