/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms;

import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.RequestElement;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.ConnectionInfo;
import ch.e2e.bridge.server.jms.JMSConnectingListenerException;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.PoolConfig;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapterPool;
import ch.e2e.bridge.server.jms.impl.IAction;
import ch.e2e.bridge.server.jms.impl.ReceiveMessageAction;
import ch.e2e.bridge.server.jms.impl.ReceiveMessageAsynchronAction;
import ch.e2e.bridge.server.jms.impl.SendMessageAction;
import ch.e2e.bridge.server.jms.parameter.JMSListenerParameter;
import ch.e2e.bridge.server.jms.parameter.JMSMessageType;
import ch.e2e.bridge.server.jms.parameter.JMSReceiveParameter;
import ch.e2e.bridge.server.jms.parameter.JMSSendParameter;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.parameter.JMSWrapperException;
import ch.e2e.bridge.server.session.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;

public class JMSAddOn
extends JavaAddOn {
    private IAction javaAction;

    public JMSAddOn(String name) {
        super(name);
    }

    @Override
    protected void initialize(String name, Request request, ArrayList<String> initializeErrors) {
        JMSLogger.getInstance().debug("1", "JMSAddOn.initialize " + name);
        RequestElement additionalConfiguration = request.getAdditionalConfiguration();
        RequestElement actionElement = additionalConfiguration.getRequestElement("Action");
        if (actionElement == null) {
            this.addRepositoryParseError("missing 'Action' element", initializeErrors);
        } else {
            String action = actionElement.getValue();
            if (action.equals("asynchronousReceive")) {
                this.javaAction = this.parseAsynchronousReceive(additionalConfiguration, name, initializeErrors);
            } else if (action.equals("send")) {
                this.javaAction = this.parseSendAction(additionalConfiguration, initializeErrors);
            } else if (action.equals("receive")) {
                this.javaAction = this.parseReceiveAction(additionalConfiguration, initializeErrors);
            } else if (action.equals("commit") || action.equals("rollback") || action.equals("recover") || action.equals("acknowledge") || action.equals("startListener") || action.equals("stopListener")) {
                this.addRepositoryParseError("action " + action + " not yet implemented", initializeErrors);
            } else {
                this.addRepositoryParseError("unkown action " + action, initializeErrors);
            }
            PoolConfig connectionPoolConfig = this.readPoolConfig(additionalConfiguration.getRequestElement("ConnectionPool"));
            ConnectionAdapterPool.getInstance().setConnectionPoolConfig(connectionPoolConfig);
            PoolConfig sessionPoolConfig = this.readPoolConfig(additionalConfiguration.getRequestElement("SessionPool"));
            ConnectionAdapterPool.getInstance().setSessionPoolConfig(sessionPoolConfig);
            if (this.javaAction != null) {
                ConnectionAdapterPool.getInstance().registerAction(this.javaAction);
            }
        }
    }

    @Override
    public void doStart() {
        this.javaAction.start();
    }

    private PoolConfig readPoolConfig(RequestElement poolConfig) {
        PoolConfig result = new PoolConfig();
        try {
            result.setMaxTotal(Integer.parseInt(poolConfig.getAttribute("maxTotal")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setMinIdle(Integer.parseInt(poolConfig.getAttribute("minIdle")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setMaxIdle(Integer.parseInt(poolConfig.getAttribute("maxIdle")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setMinEvictableIdleTimeMillis(Integer.parseInt(poolConfig.getAttribute("minEvictableIdleTimeMillis")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setTimeBetweenEvictionRunsMillis(Integer.parseInt(poolConfig.getAttribute("timeBetweenEvictionRunsMillis")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setNumTestsPerEvictionRun(Integer.parseInt(poolConfig.getAttribute("numTestsPerEvictionRun")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setMaxWaitSec(Integer.parseInt(poolConfig.getAttribute("maxWaitSec")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private IAction parseReceiveAction(RequestElement additionalConfiguration, ArrayList<String> initializeErrors) {
        JMSMessageType messageType = this.parseConnection(additionalConfiguration, initializeErrors);
        JMSSessionParameter sessionParameter = this.parseSession(additionalConfiguration, false, false, initializeErrors);
        JMSReceiveParameter receiveParameter = null;
        if (sessionParameter != null) {
            receiveParameter = this.parseReceive(additionalConfiguration, false, initializeErrors);
        }
        return new ReceiveMessageAction(messageType, sessionParameter, receiveParameter);
    }

    private IAction parseSendAction(RequestElement additionalConfiguration, ArrayList<String> initializeErrors) {
        JMSMessageType messageType = this.parseConnection(additionalConfiguration, initializeErrors);
        JMSSessionParameter sessionParameter = this.parseSession(additionalConfiguration, false, false, initializeErrors);
        JMSSendParameter sendParameter = null;
        if (sessionParameter != null) {
            sendParameter = this.parseSend(additionalConfiguration, false, initializeErrors);
        }
        return new SendMessageAction(messageType, sessionParameter, sendParameter);
    }

    private IAction parseAsynchronousReceive(RequestElement additionalConfiguration, String name, ArrayList<String> initializeErrors) {
        JMSMessageType messageType = this.parseConnection(additionalConfiguration, initializeErrors);
        JMSSessionParameter sessionParameter = this.parseSession(additionalConfiguration, true, true, initializeErrors);
        JMSReceiveParameter receiveParameter = this.parseReceive(additionalConfiguration, true, initializeErrors);
        JMSListenerParameter listenerParameter = this.parseListener(additionalConfiguration, initializeErrors);
        PoolConfig poolConfig = this.readPoolConfig(additionalConfiguration.getRequestElement("ListenerPool"));
        try {
            return new ReceiveMessageAsynchronAction(listenerParameter, messageType, sessionParameter, receiveParameter, poolConfig);
        }
        catch (Exception e) {
            throw new JMSConnectingListenerException(String.format("JMSAddOn %s: initializing JMS listener failed", name), e);
        }
    }

    private JMSSendParameter parseSend(RequestElement additionalConfiguration, boolean mandatory, ArrayList<String> initializeErrors) {
        String timeToLiveString;
        JMSSendParameter sendParameter = new JMSSendParameter();
        RequestElement destinationElement = additionalConfiguration.getRequestElement("JMSDestination");
        if (mandatory && destinationElement == null) {
            this.addRepositoryParseError("missing JMSDestination element", initializeErrors);
        } else if (destinationElement != null) {
            String nameString = destinationElement.getAttribute("name");
            if (nameString != null) {
                sendParameter.setDestinationName(nameString);
            } else {
                this.addRepositoryParseError("element JMSDestination missing name attribute", initializeErrors);
            }
        }
        RequestElement connectionElement = additionalConfiguration.getRequestElement("JMSConnection");
        if (connectionElement != null && (timeToLiveString = connectionElement.getAttribute("timeToLive")) != null) {
            try {
                sendParameter.setTimeToLive(Integer.parseInt(timeToLiveString));
            }
            catch (NumberFormatException e) {
                this.addRepositoryParseError(String.format("element JMSConnection attribute timeToLive is no number (%s)", timeToLiveString), initializeErrors);
            }
        }
        return sendParameter;
    }

    private String parseCallback(RequestElement additionalConfiguration) {
        return additionalConfiguration.getAttribute("callback");
    }

    private JMSListenerParameter parseListener(RequestElement additionalConfiguration, ArrayList<String> initializeErrors) {
        JMSListenerParameter listenerParameter = new JMSListenerParameter();
        RequestElement receiveElement = additionalConfiguration.getRequestElement("JMSConnection");
        if (receiveElement != null) {
            String listenerName = receiveElement.getAttribute("name");
            if (listenerName == null) {
                this.addRepositoryParseError("missing attribute 'name' from JMSConnection element", initializeErrors);
            } else {
                listenerParameter.setName(listenerName);
            }
        }
        return listenerParameter;
    }

    private JMSReceiveParameter parseReceive(RequestElement additionalConfiguration, boolean mandatory, ArrayList<String> initializeErrors) {
        JMSReceiveParameter receiveParameter = new JMSReceiveParameter();
        RequestElement destinationElement = additionalConfiguration.getRequestElement("JMSDestination");
        if (mandatory && destinationElement == null) {
            this.addRepositoryParseError("missing JMSDestination element", initializeErrors);
        } else if (destinationElement != null) {
            String queue = destinationElement.getAttribute("name");
            if (queue == null) {
                this.addRepositoryParseError("missing attribute 'queue' from JMSDestination element", initializeErrors);
            } else {
                receiveParameter.setDestinationName(queue);
            }
            RequestElement connectionElement = additionalConfiguration.getRequestElement("JMSConnection");
            if (connectionElement != null) {
                receiveParameter.setSelector(connectionElement.getAttribute("selector"));
            }
            receiveParameter.setCallback(this.parseCallback(additionalConfiguration));
        }
        return receiveParameter;
    }

    private JMSSessionParameter parseSession(RequestElement additionalConfiguration, boolean mandatory, boolean defaultAutomaticReconnect, ArrayList<String> initializeErrors) {
        JMSSessionParameter sessionParameter = new JMSSessionParameter();
        sessionParameter.setAutomaticReconnect(defaultAutomaticReconnect);
        RequestElement connectionElement = additionalConfiguration.getRequestElement("JMSConnection");
        boolean validParameter = this.createConnectionInfo(connectionElement, additionalConfiguration.getRequestElement("JMSContextFactory"), sessionParameter, initializeErrors, mandatory);
        if (connectionElement != null) {
            sessionParameter.setAutomaticReconnect(defaultAutomaticReconnect);
            this.parseAuthentication(sessionParameter, connectionElement);
            sessionParameter.setProperties(this.readProperties(connectionElement));
        } else if (mandatory) {
            this.addRepositoryParseError("missing JMSConnection element", initializeErrors);
        }
        return validParameter ? sessionParameter : null;
    }

    private HashMap<String, String> readProperties(RequestElement connectionElement) {
        ArrayList<RequestElement> properties;
        HashMap<String, String> propertyCollection = new HashMap<String, String>();
        RequestElement propertyElements = connectionElement.getRequestElement("Properties");
        if (propertyElements != null && (properties = propertyElements.getRequestElements("Property")) != null) {
            Iterator<RequestElement> iterator = properties.iterator();
            while (iterator.hasNext()) {
                RequestElement propertyObject;
                RequestElement property = propertyObject = iterator.next();
                String propertyName = property.getAttribute("name");
                String propertyValue = property.getAttribute("value");
                propertyCollection.put(propertyName, propertyValue);
            }
        }
        return propertyCollection;
    }

    private boolean createConnectionInfo(RequestElement connectionElement, RequestElement jmsContextFactory, JMSSessionParameter sessionParameter, ArrayList<String> initializeErrors, boolean mandatory) {
        boolean validParameter = true;
        ConnectionInfo connectionInfo = sessionParameter.getConnectionInfo();
        if (connectionElement != null) {
            String acknowledgeModeString;
            String nameString = connectionElement.getAttribute("name");
            if (nameString != null) {
                connectionInfo.setName(nameString);
            }
            if ((acknowledgeModeString = connectionElement.getAttribute("acknowledgeMode")) != null) {
                connectionInfo.setMode(acknowledgeModeString);
            }
        }
        if (jmsContextFactory != null) {
            String className;
            String contextFactory = jmsContextFactory.getAttribute("initialContextFactory") == null ? "" : jmsContextFactory.getAttribute("initialContextFactory");
            String factoryName = jmsContextFactory.getAttribute("connectionFactoryName") == null ? "" : jmsContextFactory.getAttribute("connectionFactoryName");
            String string = className = jmsContextFactory.getAttribute("connectionFactoryClassName") == null ? "" : jmsContextFactory.getAttribute("connectionFactoryClassName");
            if (mandatory && contextFactory.length() == 0 && factoryName.length() == 0 && className.length() == 0) {
                this.addRepositoryParseError("missing attribute 'connectionFactoryClassName' from JMSContextFactory element", initializeErrors);
                validParameter = false;
            } else if (mandatory && contextFactory.length() > 0 && factoryName.length() == 0) {
                this.addRepositoryParseError("missing attribute 'connectionFactoryName' from JMSContextFactory element", initializeErrors);
                validParameter = false;
            } else if (mandatory && contextFactory.length() == 0 && factoryName.length() > 0) {
                this.addRepositoryParseError("missing attribute 'initialContextFactory' from JMSContextFactory element", initializeErrors);
                validParameter = false;
            } else if (!mandatory || contextFactory.length() > 0 || className.length() > 0) {
                connectionInfo.setInitialContextFactory(contextFactory);
                connectionInfo.setConnectionFactoryName(factoryName);
                connectionInfo.setConnectionFactoryClassname(className);
                if (connectionElement != null) {
                    connectionInfo.setHost(connectionElement.getAttribute("host"));
                    try {
                        connectionInfo.setPort(Integer.parseInt(connectionElement.getAttribute("port")));
                    }
                    catch (Throwable e) {
                        connectionInfo.setPort(-1);
                    }
                    connectionInfo.setProtocol(connectionElement.getAttribute("protocol"));
                    connectionInfo.setPath(connectionElement.getAttribute("path"));
                }
            } else {
                connectionInfo.setConnectionFactoryClassname(className);
            }
            JMSLogger.getInstance().debug("JMS14", connectionInfo.dumpInfo());
        }
        return validParameter;
    }

    private void parseAuthentication(JMSSessionParameter sessionParameter, RequestElement connectionElement) {
        RequestElement authenticationElement = connectionElement.getRequestElement("Authentication");
        if (authenticationElement != null) {
            sessionParameter.getConnectionInfo().setUser(authenticationElement.getAttribute("user"));
            sessionParameter.getConnectionInfo().setPassword(authenticationElement.getAttribute("password"));
        }
    }

    private JMSMessageType parseConnection(RequestElement additionalConfiguration, ArrayList<String> initializeErrors) {
        boolean validParameter;
        JMSMessageType messageType = new JMSMessageType();
        RequestElement messageTypeElement = additionalConfiguration.getRequestElement("MessageType");
        if (messageTypeElement == null) {
            validParameter = false;
            this.addRepositoryParseError("missing element 'MessageType'", initializeErrors);
        } else {
            String messageTypeString = messageTypeElement.getValue();
            if (JMSMessageType.isValidMessageType(messageTypeString)) {
                validParameter = true;
                messageType.setMessageType(messageTypeString);
            } else {
                validParameter = false;
                this.addRepositoryParseError(String.format("incorrect value '%s' of element 'MessageType'", messageTypeString), initializeErrors);
            }
        }
        return validParameter ? messageType : null;
    }

    private void addRepositoryParseError(String message, ArrayList<String> initializeErrors) {
        initializeErrors.add(message);
    }

    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) throws Exception {
        JMSLogger.getInstance().debug("17", String.format("executing %s in session %s", this.getName(), session.getSessionId()));
        if (this.javaAction == null) {
            throw new JMSWrapperException("not implemented");
        }
        boolean result = this.javaAction.execute(inputItem, outputItem, session);
        return result;
    }

    @Override
    protected void doShutDown() {
        try {
            ConnectionAdapterPool.getInstance().shutdown();
        }
        catch (Exception e) {
            JMSLogger.getInstance().error("21", e);
        }
        super.doShutDown();
    }

    @Override
    protected void printStackTrace(Throwable t, String code) {
        if (!(t instanceof JMSWrapperException)) {
            if (t instanceof JMSException) {
                JMSException jmsException = (JMSException)t;
                Exception linkedException = jmsException.getLinkedException();
                if (linkedException == null) {
                    JMSLogger.getInstance().debug(code, "JMSException has no linked exception.", t);
                } else {
                    JMSLogger.getInstance().debug(code, "JMSException linked exception: " + jmsException.getLinkedException().getMessage(), t);
                }
            } else {
                JMSLogger.getInstance().debug(code, t);
            }
        }
    }
}

