/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms;

import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;

public class ConnectionInfo
implements Cloneable {
    private String connectionFactoryClassname;
    private String connectionFactoryName;
    private String initialContextFactory;
    private String host;
    private String protocol;
    private int port = -1;
    private String path;
    private String name = "anonymous";
    private String user;
    private String password;
    private boolean transacted = false;
    private int acknowledgeMode = 1;
    private HashMap<String, String> properties = new HashMap();
    private String id;

    public String getConnectionFactoryClassname() {
        return this.connectionFactoryClassname;
    }

    public void setConnectionFactoryClassname(String connectionFactoryClassname) {
        this.connectionFactoryClassname = connectionFactoryClassname;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public boolean isNamingConnection() {
        return this.connectionFactoryClassname == null || this.connectionFactoryClassname.length() == 0;
    }

    public String getURL() {
        String url;
        String host;
        String protocol = this.protocol == null ? "noProtocol" : this.protocol;
        String string = host = this.host == null ? "noHost" : this.host;
        if (protocol.equals("file")) {
            if (this.path != null) {
                File file = new File(this.path);
                try {
                    url = file.toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    url = protocol + "://";
                }
            } else {
                url = protocol + "://";
            }
        } else {
            String[] hosts = host.split(" ");
            StringBuilder urlBuilder = new StringBuilder();
            for (String h : hosts) {
                urlBuilder.append(" ");
                if (h != null && h.length() > 0) {
                    urlBuilder.append(protocol).append("://").append(h);
                    if (this.port != -1) {
                        urlBuilder.append(":").append(this.port);
                    }
                }
                if (this.path == null || this.path.length() <= 0) continue;
                urlBuilder.append('/').append(this.path);
            }
            url = urlBuilder.toString();
        }
        return url.trim();
    }

    public void setHost(String host) {
        this.host = host == null ? null : host.trim();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol == null ? null : protocol.trim();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean getTransacted() {
        return this.transacted;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public String getMode() {
        if (this.transacted) {
            return "Transacted";
        }
        switch (this.acknowledgeMode) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Client";
            }
            case 3: {
                return "Duplicate";
            }
        }
        return null;
    }

    public void setMode(String acknowledgeModeString) {
        if (acknowledgeModeString == null) {
            this.setAcknowledgeMode(1);
        } else if (acknowledgeModeString.equalsIgnoreCase("auto")) {
            this.setAcknowledgeMode(1);
        } else if (acknowledgeModeString.equalsIgnoreCase("client")) {
            this.setAcknowledgeMode(2);
        } else if (acknowledgeModeString.equalsIgnoreCase("duplicate")) {
            this.setAcknowledgeMode(3);
        } else if (acknowledgeModeString.equalsIgnoreCase("transacted")) {
            this.setTransacted(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    public boolean merge(RecordItem item) {
        boolean changed = false;
        if (item != null) {
            if (item.getItem(0L) != null) {
                this.setMode(item.getItem(0L).getValueAsString());
                changed = true;
            }
            if (item.getItem(1L) != null) {
                this.setName(item.getItem(1L).getValueAsString());
                changed = true;
            }
            if (item.getItem(2L) != null) {
                this.setUser(item.getItem(2L).getValueAsString());
                changed = true;
            }
            if (item.getItem(3L) != null) {
                this.setPassword(item.getItem(3L).getValueAsString());
                changed = true;
            }
            if (item.getItem(4L) != null) {
                this.setPath(item.getItem(4L).getValueAsString());
                changed = true;
            }
            if (item.getItem(5L) != null) {
                this.setProtocol(item.getItem(5L).getValueAsString());
                changed = true;
            }
            if (item.getItem(6L) != null) {
                this.setHost(item.getItem(6L).getValueAsString());
                changed = true;
            }
            if (item.getItem(7L) != null) {
                this.setPort(item.getItem(7L).intValue());
                changed = true;
            }
            if (item.getItem(8L) == null) {
                this.properties.clear();
            } else {
                ArrayItem properties = (ArrayItem)item.getItem(8L);
                int length = properties.size();
                for (int i = 0; i < length; ++i) {
                    RecordItem property = (RecordItem)properties.getItem(i);
                    if (property.getItem(0L) == null || property.getItem(1L) == null) continue;
                    this.properties.put(property.getItem(0L).getValueAsString(), property.getItem(1L).getValueAsString());
                }
                changed = true;
            }
        }
        return changed;
    }

    public boolean equals(ConnectionInfo connectionInfo) {
        return this.getId().equals(connectionInfo.getId());
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ConnectionInfo && this.equals((ConnectionInfo)obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public Object clone() {
        ConnectionInfo clone = new ConnectionInfo();
        clone.connectionFactoryClassname = this.connectionFactoryClassname;
        clone.connectionFactoryName = this.connectionFactoryName;
        clone.initialContextFactory = this.initialContextFactory;
        clone.host = this.host;
        clone.protocol = this.protocol;
        clone.port = this.port;
        clone.path = this.path;
        clone.name = this.name;
        clone.user = this.user;
        clone.password = this.password;
        clone.transacted = this.transacted;
        clone.acknowledgeMode = this.acknowledgeMode;
        clone.properties = (HashMap)this.properties.clone();
        return clone;
    }

    public String dumpInfo() {
        StringBuilder info = new StringBuilder("ConnectionInfo:\n");
        info.append("connectionName: ").append(this.name == null ? "null" : this.name).append('\n');
        info.append("connectionFactoryClassname: ").append(this.connectionFactoryClassname == null ? "null" : this.connectionFactoryClassname).append('\n');
        info.append("initialContextFactory: ").append(this.initialContextFactory == null ? "null" : this.initialContextFactory).append('\n');
        info.append("connectionFactoryName: ").append(this.connectionFactoryName == null ? "null" : this.connectionFactoryName).append('\n');
        info.append("protocol: ").append(this.protocol == null ? "null" : this.protocol).append('\n');
        info.append("host: ").append(this.host == null ? "null" : this.host).append('\n');
        info.append("port: ").append(this.port == -1 ? "null" : Integer.valueOf(this.port)).append('\n');
        info.append("path: ").append(this.path == null ? "null" : this.path).append('\n');
        info.append("user: ").append(this.user == null ? "null" : this.user).append('\n');
        info.append("password: ").append(this.password == null ? "null" : "*****").append('\n');
        info.append("mode: ").append(this.getMode()).append('\n');
        return info.toString();
    }

    public void resetId() {
        this.id = null;
    }

    public String getHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    private String getId() {
        if (this.id == null) {
            StringBuilder idBuilder = new StringBuilder(this.isNamingConnection() ? this.connectionFactoryClassname + this.initialContextFactory : (this.connectionFactoryName == null ? "" : this.connectionFactoryName));
            idBuilder.append(this.getURL()).append(this.getMode()).append(this.name).append(this.user).append(this.password).append(this.getTransacted());
            for (String key : this.properties.keySet()) {
                idBuilder.append(key).append(this.properties.get(key));
            }
            this.id = idBuilder.toString();
        }
        return this.id;
    }
}

