/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.fop;

import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.RequestElement;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.fop.FOPConfiguration;
import ch.e2e.bridge.server.fop.FopLogger;
import ch.e2e.bridge.server.fop.FopProcessor;
import ch.e2e.bridge.server.session.Session;
import ch.e2e.bridge.server.xslt.TransformerLoader;
import ch.e2e.bridge.server.xslt.XSLTExtractUtilities;
import ch.e2e.bridge.server.xslt.XSLTScript;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public class FOPAddOn
extends JavaAddOn {
    private static FopFactory fopFactory = FopFactory.newInstance();
    private XSLTScript script;
    private FopProcessor fopProcessor;

    public FOPAddOn(String name) {
        super(name);
    }

    @Override
    protected void initialize(String name, Request request, ArrayList<String> initializeErrors) {
        RequestElement config = request.getAdditionalConfiguration();
        RequestElement processor = config.getRequestElement("FOPProcessor");
        String renderer = this.getRenderer(processor.getAttribute("renderer"));
        String transformerFactory = processor.getAttribute("transformerFactory");
        this.fopProcessor = new FopProcessor(renderer, transformerFactory);
        this.script = this.readXSLTConfiguration(config, transformerFactory, processor.getRequestElements("XSLTArchive"));
        try {
            FOPConfiguration configuration = new FOPConfiguration(processor.getAttribute("userconfig"));
            fopFactory.setUserConfig(configuration.getFile());
        }
        catch (Exception e) {
            initializeErrors.add(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) {
        boolean result = false;
        BlobItem input = inputItem.getBlobItem(0);
        InputStream in = input.getValueAsInputStream(InputStream.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        try {
            Fop fop = fopFactory.newFop(this.fopProcessor.getRenderer(), (OutputStream)bufOut);
            if (this.script == null) {
                this.renderWithoutXSLT(in, fop);
            } else {
                this.renderWithXSLT(in, fop, session);
            }
            bufOut.flush();
            BlobItem resultItem = ItemFactory.createBlobItem(session);
            resultItem.setValueFromByteArray(out.toByteArray());
            outputItem.addItem(resultItem);
            result = true;
        }
        catch (Exception e) {
            this.doErrorHandling(e, session, "0");
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private void renderWithXSLT(InputStream in, Fop fop, Session session) throws Exception {
        Transformer transformer = TransformerLoader.getInstance().borrowTransformer(this.script, session);
        this.transform(in, fop, transformer);
        TransformerLoader.getInstance().returnTransformer(this.script, transformer);
    }

    private void renderWithoutXSLT(InputStream in, Fop fop) throws Exception {
        this.transform(in, fop, TransformerLoader.getInstance().newTransformer(this.fopProcessor.getTransformerFactory()));
    }

    private void transform(InputStream in, Fop fop, Transformer transformer) throws FOPException, TransformerException {
        StreamSource src = new StreamSource(in);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
    }

    private String getRenderer(String renderer) {
        String result = renderer.equalsIgnoreCase("AWTRenderer") ? "application/X-fop-awt-preview" : (renderer.equalsIgnoreCase("MIFRenderer") ? "application/mif" : (renderer.equalsIgnoreCase("PCLRenderer") ? "application/x-pcl" : (renderer.equalsIgnoreCase("PDFRenderer") ? "application/pdf" : (renderer.equalsIgnoreCase("PRINTRenderer") ? "application/postscript" : (renderer.equalsIgnoreCase("PSRenderer") ? "application/postscript" : (renderer.equalsIgnoreCase("SVGRenderer") ? "image/svg+xml" : (renderer.equalsIgnoreCase("TXTRenderer") ? "text/plain" : (renderer.equalsIgnoreCase("XMLRenderer") ? "text/plain" : "text/plain"))))))));
        return result;
    }

    private synchronized XSLTScript readXSLTConfiguration(RequestElement config, String transformerFactory, ArrayList<RequestElement> xsltArchives) {
        XSLTScript result = null;
        RequestElement scriptConfig = config.getRequestElement("XSLTScript");
        if (scriptConfig != null) {
            result = new XSLTScript(scriptConfig.getAttribute("name"), transformerFactory);
        }
        XSLTExtractUtilities.unpackXSLTArchives(xsltArchives);
        return result;
    }

    @Override
    protected void printStackTrace(Throwable t, String code) {
        FopLogger.getInstance().debug(code, t);
    }
}

