/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem;

import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.BooleanItem;
import ch.e2e.bridge.server.dataitem.DateTimeItem;
import ch.e2e.bridge.server.dataitem.FloatItem;
import ch.e2e.bridge.server.dataitem.IntegerItem;
import ch.e2e.bridge.server.dataitem.SimpleItem;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class StringItem
extends SimpleItem {
    private static native long nativeCreate();

    private static native byte[] nativeGetContent(long var0);

    private static native void nativeSetString(long var0, String var2);

    private static native long nativeConvertToBlobItem(long var0);

    private static native long nativeConvertToBooleanItem(long var0);

    private static native long nativeConvertToDateTimeItem(long var0);

    private static native long nativeConvertToFloatItem(long var0);

    private static native long nativeConvertToIntegerItem(long var0);

    StringItem() {
        super(StringItem.nativeCreate());
    }

    StringItem(long nativeItem) {
        super(nativeItem);
    }

    public void setValueFromString(String value) throws UnsupportedEncodingException {
        StringItem.nativeSetString(this.getNativeItem(), value);
    }

    public BlobItem convertToBlobItem() {
        return new BlobItem(StringItem.nativeConvertToBlobItem(this.getNativeItem()));
    }

    public BooleanItem convertToBooleanItem() {
        return new BooleanItem(StringItem.nativeConvertToBooleanItem(this.getNativeItem()));
    }

    public DateTimeItem convertToDateTimeItem() {
        return new DateTimeItem(StringItem.nativeConvertToDateTimeItem(this.getNativeItem()));
    }

    public FloatItem convertToFloatItem() {
        return new FloatItem(StringItem.nativeConvertToFloatItem(this.getNativeItem()));
    }

    public IntegerItem convertToIntegerItem() {
        return new IntegerItem(StringItem.nativeConvertToIntegerItem(this.getNativeItem()));
    }

    @Override
    public String getValueAsString() {
        byte[] bytes = StringItem.nativeGetContent(this.getNativeItem());
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public StringBuffer getValueAsStringBuffer() {
        StringBuffer result = null;
        try {
            result = new StringBuffer(this.getValueAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public StringBuilder getValueAsStringBuilder() {
        StringBuilder result = null;
        try {
            result = new StringBuilder(this.getValueAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Character getValueAsCharacter() {
        Character result = null;
        try {
            result = Character.valueOf(this.getValueAsString().charAt(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object getValue() {
        String result = null;
        try {
            result = this.getValueAsString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public char charValue() {
        char result = '\u0000';
        try {
            result = this.getValueAsString().charAt(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void setValue(char value) {
        this.setValue(String.valueOf(value));
    }

    @Override
    public void setValue(Object value) {
        try {
            this.setValueFromString(value == null ? null : value.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

