/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem;

import ch.e2e.bridge.server.dataitem.SimpleItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class IntegerItem
extends SimpleItem {
    private static native long nativeCreate();

    private static native long nativeGetValueAslong(long var0);

    private static native void nativeSetValueFromlong(long var0, long var2);

    private static native long nativeConvertToStringItem(long var0);

    private static native void nativeSetValue(long var0, long var2);

    private static native void nativeAdd(long var0, long var2);

    private static native void nativeSubtract(long var0, long var2);

    private static native void nativeMultiply(long var0, long var2);

    private static native long nativeDivide(long var0, long var2);

    private static native void nativeChangeSign(long var0);

    private static native void nativeSetSign(long var0, boolean var2);

    private static native long nativeSquare(long var0);

    private static native long nativeSquareRoot(long var0);

    private static native void nativeRightShift(long var0);

    private static native void nativeLeftShift(long var0);

    private static native void nativeRightDigitShift(long var0);

    private static native void nativeLeftDigitShift(long var0);

    private static native byte nativeCompare(long var0, long var2);

    private static native boolean nativeIsPositive(long var0);

    private static native boolean nativeIsEven(long var0);

    private static native boolean nativeIsNull(long var0);

    private static native long nativeGetNumberOfDigits(long var0);

    private static native short nativeGetDigit(long var0, long var2);

    private static native byte[] nativeConvertToString(long var0);

    private static native boolean nativeConvertFromString(long var0, byte[] var2);

    private static native byte[] nativeConvertToFractionedString(long var0, long var2);

    IntegerItem() {
        super(IntegerItem.nativeCreate());
    }

    IntegerItem(long nativeItem) {
        super(nativeItem);
    }

    public StringItem convertToStringItem() {
        return new StringItem(IntegerItem.nativeConvertToStringItem(this.getNativeItem()));
    }

    @Override
    public byte byteValue() {
        return (byte)IntegerItem.nativeGetValueAslong(this.getNativeItem());
    }

    @Override
    public Byte getValueAsByte() {
        return this.byteValue();
    }

    @Override
    public short shortValue() {
        return (short)IntegerItem.nativeGetValueAslong(this.getNativeItem());
    }

    @Override
    public Short getValueAsShort() {
        return this.shortValue();
    }

    @Override
    public int intValue() {
        return (int)IntegerItem.nativeGetValueAslong(this.getNativeItem());
    }

    @Override
    public Integer getValueAsInteger() {
        return this.intValue();
    }

    @Override
    public long longValue() {
        return IntegerItem.nativeGetValueAslong(this.getNativeItem());
    }

    @Override
    public Long getValueAsLong() {
        return this.longValue();
    }

    @Override
    public BigInteger getValueAsBigInteger() {
        long value = this.longValue();
        System.out.println("creating BigInteger from long " + value);
        return BigInteger.valueOf(value);
    }

    @Override
    public Object getValue() {
        return IntegerItem.nativeGetValueAslong(this.getNativeItem());
    }

    @Override
    public void setValue(byte value) {
        IntegerItem.nativeSetValueFromlong(this.getNativeItem(), value);
    }

    @Override
    public void setValue(short value) {
        IntegerItem.nativeSetValueFromlong(this.getNativeItem(), value);
    }

    @Override
    public void setValue(int value) {
        IntegerItem.nativeSetValueFromlong(this.getNativeItem(), value);
    }

    @Override
    public void setValue(long value) {
        IntegerItem.nativeSetValueFromlong(this.getNativeItem(), value);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof BigInteger) {
            this.convertFromString(value.toString());
        } else if (value instanceof Number) {
            IntegerItem.nativeSetValueFromlong(this.getNativeItem(), ((Number)value).longValue());
        } else {
            super.setValue(value);
        }
    }

    public void setValue(IntegerItem Value) {
        IntegerItem.nativeSetValue(this.getNativeItem(), Value.getNativeItem());
    }

    public void add(IntegerItem Value) {
        IntegerItem.nativeAdd(this.getNativeItem(), Value.getNativeItem());
    }

    public void subtract(IntegerItem Value) {
        IntegerItem.nativeSubtract(this.getNativeItem(), Value.getNativeItem());
    }

    public void multiply(IntegerItem Value) {
        IntegerItem.nativeMultiply(this.getNativeItem(), Value.getNativeItem());
    }

    public IntegerItem divide(IntegerItem Value) {
        return new IntegerItem(IntegerItem.nativeDivide(this.getNativeItem(), Value.getNativeItem()));
    }

    public void changeSign() {
        IntegerItem.nativeChangeSign(this.getNativeItem());
    }

    public void setSign(boolean Sign) {
        IntegerItem.nativeSetSign(this.getNativeItem(), Sign);
    }

    public IntegerItem square() {
        return new IntegerItem(IntegerItem.nativeSquare(this.getNativeItem()));
    }

    public IntegerItem squareRoot() {
        return new IntegerItem(IntegerItem.nativeSquareRoot(this.getNativeItem()));
    }

    public void rightShift() {
        IntegerItem.nativeRightShift(this.getNativeItem());
    }

    public void leftShift() {
        IntegerItem.nativeLeftShift(this.getNativeItem());
    }

    public void rightDigitShift() {
        IntegerItem.nativeRightDigitShift(this.getNativeItem());
    }

    public void leftDigitShift() {
        IntegerItem.nativeLeftDigitShift(this.getNativeItem());
    }

    public byte compare(IntegerItem value) {
        return IntegerItem.nativeCompare(this.getNativeItem(), value.getNativeItem());
    }

    public boolean isPositive() {
        return IntegerItem.nativeIsPositive(this.getNativeItem());
    }

    public boolean isEven() {
        return IntegerItem.nativeIsEven(this.getNativeItem());
    }

    public boolean isNull() {
        return IntegerItem.nativeIsNull(this.getNativeItem());
    }

    public long getNumberOfDigits() {
        return IntegerItem.nativeGetNumberOfDigits(this.getNativeItem());
    }

    public short getDigit(long index) {
        return IntegerItem.nativeGetDigit(this.getNativeItem(), index);
    }

    public String convertToString() {
        return new String(IntegerItem.nativeConvertToString(this.getNativeItem()), StandardCharsets.UTF_8);
    }

    public boolean convertFromString(String value) {
        System.out.println("Calling nativeConvertFromString with String " + value);
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        System.out.printf("Calling nativeConvertFromString with bytes: length = %d\nbytes = %n", bytes.length);
        for (byte aByte : bytes) {
            System.out.print(aByte);
        }
        System.out.println();
        return IntegerItem.nativeConvertFromString(this.getNativeItem(), bytes);
    }

    public String convertToFractionedString(long fractionLength) throws UnsupportedEncodingException {
        return new String(IntegerItem.nativeConvertToFractionedString(this.getNativeItem(), fractionLength), StandardCharsets.UTF_8);
    }
}

