/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.BridgeRepositoryException;
import ch.e2e.bridge.server.BridgeSecurityManager;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.ServerLogger;
import ch.e2e.bridge.server.SystemOutputDestination;
import ch.e2e.crypto.CryptographyFactory;
import ch.e2e.crypto.Decrypt;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.OutputDestination;
import ch.e2e.io.SystemErrRedirector;
import ch.e2e.io.SystemOutRedirector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaVirtualMachine {
    public static final String INSTANCES_HOME_VARIABLE = "INSTANCES_HOME";
    public static final String BRIDGESERVER_HOME_VARIABLE = "BRIDGESERVER_BIN";
    public static final String CONSOLE_HOME_VARIABLE = "CONSOLE_HOME";
    public static boolean shutdown = false;
    private static File instancesHome;
    private static File bridgeServerHome;
    private static File consoleHome;
    private static File repositoryPath;
    private static File jarfilesPath;
    private static boolean initialize;
    private static boolean killThreadsOnShutdown;
    private static HashMap<String, Request> executables;
    private static ArrayList<Thread> startThreads;
    private static ArrayList<Method> shutdownMethods;
    private static String runtimeVersion;

    public static boolean initialize(String runtimeVersion) {
        JavaVirtualMachine.runtimeVersion = runtimeVersion;
        return true;
    }

    public static String getRuntimeVersion() {
        return runtimeVersion == null ? "5.1.80.0" : runtimeVersion;
    }

    public static void initialize() {
        if (initialize) {
            initialize = false;
            long initialMemory = Runtime.getRuntime().totalMemory();
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            if (startThreads == null) {
                startThreads = new ArrayList<Thread>(Thread.getAllStackTraces().keySet());
            }
            bridgeServerHome = new File(System.getProperty(BRIDGESERVER_HOME_VARIABLE));
            try {
                Runtime.getRuntime().loadLibrary("Java_AddOn");
            }
            catch (Throwable t) {
                File library = new File(bridgeServerHome, "Java_AddOn");
                Runtime.getRuntime().load(library.getAbsolutePath());
            }
            ServerLogger logger = ServerLogger.getInstance();
            JavaVirtualMachine.redirectOutErr();
            logger.debug("5", "System.out and System.err redirected.");
            try {
                System.setSecurityManager(new BridgeSecurityManager());
            }
            catch (Throwable t) {
                logger.error("4", "Security manager failed", t);
            }
            instancesHome = new File(System.getProperty(INSTANCES_HOME_VARIABLE));
            consoleHome = bridgeServerHome.getParentFile().getParentFile();
            logger.info("3", JavaVirtualMachine.versionInfo(initialMemory));
        }
    }

    public static HashMap<String, Request> getExecutables() {
        return executables;
    }

    public static void setConfiguration(String file) {
        JavaVirtualMachine.setConfiguration(new File(file));
    }

    public static void setConfiguration(String repositoryPath, String file) {
        JavaVirtualMachine.repositoryPath = new File(repositoryPath);
        JavaVirtualMachine.setConfiguration(new File(JavaVirtualMachine.repositoryPath, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfiguration(File file) {
        ArrayList<String> initializeErrors = new ArrayList<String>();
        InputStream input = null;
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            Decrypt decrypt = CryptographyFactory.getDecryption((String)"e2ecrypt01");
            input = decrypt.getCipherInputStream(file);
            Document tabfileDoc = DomUtilities.parse((InputStream)input, (boolean)false, (boolean)false);
            Element root = tabfileDoc.getDocumentElement();
            DomUtilities.removeAllNotElementEmptyNodes((Element)root);
            JavaVirtualMachine.readVirtualMachine((Element)root.getElementsByTagName("VirtualMachine").item(0), initializeErrors);
            NodeList executables = root.getElementsByTagName("Execute");
            int length = executables.getLength();
            for (int i = 0; i < length; ++i) {
                Request request = new Request(executables.item(i));
                JavaVirtualMachine.executables.put(request.getName(), request);
            }
        }
        catch (Exception e) {
            ServerLogger.getInstance().error("6", "Could not load the tabfile document.", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            JavaVirtualMachine.printAllInitializeErrors(JavaVirtualMachine.class, "VirtualMachine", initializeErrors);
        }
    }

    private static void readVirtualMachine(Element virtualMachine, ArrayList<String> initializeErrors) {
        killThreadsOnShutdown = DomUtilities.getBoolean((Element)virtualMachine, (String)"killThreadsOnShutdown", (boolean)true);
        shutdownMethods = new ArrayList();
        NodeList shutdowns = virtualMachine.getElementsByTagName("Shutdown");
        int length = shutdowns.getLength();
        for (int i = 0; i < length; ++i) {
            Element shutdown = (Element)shutdowns.item(i);
            try {
                Class<?> shutdownClass = Class.forName(shutdown.getAttribute("class"));
                Method method = shutdownClass.getMethod(shutdown.getAttribute("method"), new Class[0]);
                shutdownMethods.add(method);
                continue;
            }
            catch (Exception e) {
                initializeErrors.add(e.getMessage());
            }
        }
    }

    public static File getRepositoryPath() {
        return repositoryPath;
    }

    public static File getInstancesHome() {
        return instancesHome;
    }

    public static File getBridgeServerHome() {
        return bridgeServerHome;
    }

    public static File getConsoleHome() {
        return consoleHome;
    }

    public static File getJarfilesPath() {
        return jarfilesPath;
    }

    public static void shutdown() {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        for (Method method : shutdownMethods) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                ServerLogger.getInstance().error("1", "Shutdown failed", e);
            }
        }
        if (killThreadsOnShutdown) {
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (startThreads.contains(thread)) continue;
                ServerLogger.getInstance().info("2", "Stop thread " + thread.getName());
                thread.stop();
            }
        }
    }

    public static void printAllInitializeErrors(Class clazz, String name, ArrayList<String> initializeErrors) {
        if (initializeErrors.size() > 0) {
            String classname = clazz.getName();
            int index = classname.lastIndexOf(46);
            if (index != -1) {
                classname = classname.substring(index + 1);
            }
            StringBuilder message = new StringBuilder().append(classname).append(" ").append(name).append(": repository is invalid (").append(initializeErrors.size()).append(" errors):");
            for (String error : initializeErrors) {
                message.append("\n").append(error);
            }
            throw new BridgeRepositoryException(message.toString());
        }
    }

    private static void redirectOutErr() {
        SystemOutputDestination out = new SystemOutputDestination("JAVA_OUT");
        SystemOutRedirector.getInstance().addOutputDestination((OutputDestination)out);
        SystemOutRedirector.getInstance().setEnabled(true);
        SystemOutRedirector.getInstance().setOriginalStreamEnabled(false);
        SystemOutputDestination err = new SystemOutputDestination("JAVA_ERR");
        SystemErrRedirector.getInstance().addOutputDestination((OutputDestination)err);
        SystemErrRedirector.getInstance().setEnabled(true);
        SystemErrRedirector.getInstance().setOriginalStreamEnabled(false);
    }

    private static String versionInfo(long initialMemory) {
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String vmInfo = System.getProperty("java.vm.info");
        String version = System.getProperty("java.version");
        String vendor = System.getProperty("java.vendor");
        StringBuilder sb = new StringBuilder();
        sb.append("Start JVM with addon.jar: ").append(JavaVirtualMachine.addonVersion()).append('\n').append("JVM: ").append(vmVersion).append(", ").append(vmName).append(", ").append(vmInfo).append('\n').append("Java: ").append(version).append(", ").append(vendor).append('\n').append("Initial amount of memory: ").append(initialMemory / 1024L / 1024L).append(" MB\n").append("Maximum amount of memory: ").append(Runtime.getRuntime().maxMemory() / 1024L / 1024L).append(" MB\n");
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (!inputArguments.isEmpty()) {
            sb.append("JVM arguments:");
            for (String arg : inputArguments) {
                sb.append('\n').append(arg);
            }
        }
        return sb.toString();
    }

    private static String addonVersion() {
        int addonIndex;
        String classpath = System.getProperty("java.class.path");
        String addonPath = classpath.substring(0, (addonIndex = classpath.indexOf("addon.jar")) + 9);
        int index = addonPath.lastIndexOf(File.pathSeparatorChar);
        if (index != -1) {
            addonPath = addonPath.substring(index + 1);
        }
        try {
            jarfilesPath = new File(addonPath).getParentFile();
            JarFile addonJar = new JarFile(addonPath);
            Manifest addonManifest = addonJar.getManifest();
            return addonManifest.getMainAttributes().getValue("Module-Version");
        }
        catch (IOException e) {
            return "No addon.jar version found.";
        }
    }

    static {
        initialize = true;
        killThreadsOnShutdown = true;
        executables = new HashMap();
        startThreads = null;
        shutdownMethods = null;
        JavaVirtualMachine.initialize();
    }
}

