/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.BridgeJavaService;
import ch.e2e.bridge.server.BridgeJavaServiceStartStopInterface;
import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.bridge.server.JavaCallbackImplementation;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.RequestElement;
import ch.e2e.bridge.server.ServerLogger;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.session.Session;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class JavaService
extends JavaAddOn {
    private BridgeJavaService service;

    public JavaService(String name) {
        super(name);
    }

    @Override
    protected void initialize(String name, Request request, ArrayList<String> initializeErrors) {
        RequestElement additionalConfiguration = request.getAdditionalConfiguration();
        RequestElement callbackService = additionalConfiguration.getRequestElement("CallbackService");
        String serviceClassname = callbackService.getAttribute("class");
        try {
            Class<?> serviceClass = Class.forName(serviceClassname);
            this.service = (BridgeJavaService)serviceClass.newInstance();
            ArrayList<RequestElement> interfaces = callbackService.getRequestElements("Interface");
            for (RequestElement anInterface : interfaces) {
                try {
                    Class<?> implementationClass = Class.forName(anInterface.getAttribute("implementation"));
                    JavaCallbackImplementation implementation = (JavaCallbackImplementation)implementationClass.newInstance();
                    String interfaceName = anInterface.getAttribute("class");
                    implementation.setCallbacks(this.getCallbacks(interfaceName, request));
                    Class<?> interfaceClass = Class.forName(interfaceName);
                    Method initialize = serviceClass.getMethod("initialize", interfaceClass);
                    initialize.invoke((Object)this.service, implementation);
                }
                catch (Exception e) {
                    initializeErrors.add(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            initializeErrors.add(e.getMessage());
        }
    }

    @Override
    public final boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) {
        return false;
    }

    @Override
    public void doShutDown() {
        if (this.service != null) {
            try {
                this.service.shutDown();
            }
            catch (Exception e) {
                ServerLogger.getInstance().error("1", "Shutdown failed", e);
            }
        }
        super.doShutDown();
    }

    private HashMap<String, String> getCallbacks(String interfaceName, Request request) {
        ArrayList<RequestElement> ports = request.getAdditionalConfiguration().getRequestElements("Port");
        RequestElement port = null;
        int length = ports.size();
        for (int i = 0; i < length && port == null; ++i) {
            RequestElement requestElement = ports.get(i);
            if (!requestElement.getAttribute("realizingInterface").equals(interfaceName)) continue;
            port = requestElement;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (port != null) {
            ArrayList<RequestElement> operations = port.getRequestElements("Operation");
            for (RequestElement operation : operations) {
                result.put(operation.getAttribute("key"), operation.getAttribute("callback"));
            }
        }
        return result;
    }

    @Override
    protected void doStart() {
        if (this.service instanceof BridgeJavaServiceStartStopInterface) {
            ((BridgeJavaServiceStartStopInterface)((Object)this.service)).start();
        }
    }

    @Override
    protected void doStop() {
        if (this.service instanceof BridgeJavaServiceStartStopInterface) {
            ((BridgeJavaServiceStartStopInterface)((Object)this.service)).stop();
        }
    }
}

