/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.dataitem.BooleanItem;
import ch.e2e.bridge.server.dataitem.FloatItem;
import ch.e2e.bridge.server.dataitem.IntegerItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;

public class DefaultValues {
    private DefaultValues() {
    }

    public static byte byteDefault(int index, RecordItem parent) {
        DefaultValues.createIntegerItem(index, parent);
        return 0;
    }

    public static char charDefault(int index, RecordItem parent) {
        StringItem result = ItemFactory.createStringItem(parent.getSession());
        result.setValue("");
        parent.setItem(index, result, true);
        return '\u0000';
    }

    public static short shortDefault(int index, RecordItem parent) {
        DefaultValues.createIntegerItem(index, parent);
        return 0;
    }

    public static int intDefault(int index, RecordItem parent) {
        DefaultValues.createIntegerItem(index, parent);
        return 0;
    }

    public static long longDefault(int index, RecordItem parent) {
        DefaultValues.createIntegerItem(index, parent);
        return 0L;
    }

    public static float floatDefault(int index, RecordItem parent) {
        DefaultValues.createFloatItem(index, parent);
        return 0.0f;
    }

    public static double doubleDefault(int index, RecordItem parent) {
        DefaultValues.createFloatItem(index, parent);
        return 0.0;
    }

    public static boolean booleanDefault(int index, RecordItem parent) {
        BooleanItem result = ItemFactory.createBooleanItem(parent.getSession());
        result.setValue(false);
        parent.setItem(index, result, true);
        return false;
    }

    private static void createIntegerItem(int index, RecordItem parent) {
        IntegerItem result = ItemFactory.createIntegerItem(parent.getSession());
        result.setValue(0);
        parent.setItem(index, result, true);
    }

    private static void createFloatItem(int index, RecordItem parent) {
        FloatItem result = ItemFactory.createFloatItem(parent.getSession());
        result.setValue(0);
        parent.setItem(index, result, true);
    }
}

