/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.xlibdoc.util;

import com.scheer.xlibdoc.model.XlibException;
import com.scheer.xlibdoc.util.Formatter;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.util.DocTreeScanner;
import java.util.ArrayList;
import java.util.List;

public class XlibDocTreeScanner
extends DocTreeScanner<Void, Void> {
    private String description;
    private String returnDescription;
    private final List<XlibException> exceptions = new ArrayList<XlibException>();

    private XlibDocTreeScanner() {
    }

    public static XlibDocTreeScanner newScanner(DocTree docTree) {
        XlibDocTreeScanner scanner = new XlibDocTreeScanner();
        scanner.scan(docTree, null);
        return scanner;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReturnDescription() {
        return this.returnDescription;
    }

    public List<XlibException> getExceptions() {
        return this.exceptions;
    }

    @Override
    public Void visitDocComment(DocCommentTree node, Void unused) {
        this.description = Formatter.toString(node.getFullBody());
        return (Void)super.visitDocComment(node, unused);
    }

    @Override
    public Void visitReturn(ReturnTree node, Void unused) {
        this.returnDescription = Formatter.toString(node.getDescription());
        return (Void)super.visitReturn(node, unused);
    }

    @Override
    public Void visitThrows(ThrowsTree node, Void unused) {
        this.exceptions.add(new XlibException(node));
        return (Void)super.visitThrows(node, unused);
    }
}

