/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.xlibdoc.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.scheer.xlibdoc.model.XlibException;
import com.scheer.xlibdoc.model.XlibParameter;
import com.scheer.xlibdoc.util.XlibDocTreeScanner;
import com.sun.source.doctree.DocTree;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;

public class XlibMethod {
    @JsonProperty(required=true)
    private final String signature;
    @JsonProperty(required=true)
    private final String name;
    @JsonProperty
    private final String returnDescription;
    @JsonProperty
    private final String description;
    @JsonProperty
    private List<XlibParameter> parameters = new ArrayList<XlibParameter>();
    @JsonProperty
    private List<XlibException> exceptions = new ArrayList<XlibException>();

    public XlibMethod(ExecutableElement e, DocTree docTree) {
        this.signature = XlibMethod.signature(e);
        this.name = e.getSimpleName().toString();
        XlibDocTreeScanner scanner = XlibDocTreeScanner.newScanner(docTree);
        this.description = scanner.getDescription();
        this.returnDescription = scanner.getReturnDescription();
        this.exceptions = scanner.getExceptions();
    }

    public void addParameter(XlibParameter parameter) {
        this.parameters.add(parameter);
    }

    private static String signature(ExecutableElement e) {
        return e.getParameters().stream().map(p -> p.asType().toString()).collect(Collectors.joining(", ", e.getReturnType().toString() + " " + e.getSimpleName() + "(", ")"));
    }
}

