/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.xlibdoc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.scheer.xlibdoc.model.Xlib;
import com.scheer.xlibdoc.util.XlibElementScanner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.SourceVersion;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class XlibDoclet
implements Doclet {
    private static final String FILENAME = "xlib.yaml";
    private final Set<Doclet.Option> options = this.options();
    private final ObjectMapper objectMapper = XlibDoclet.newObjectMapper();
    private File outputFile = new File("build/docs/xlibdoc", "xlib.yaml");

    @Override
    public void init(Locale locale, Reporter reporter) {
    }

    @Override
    public String getName() {
        return "LibraryDoclet";
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return this.options;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        try {
            XlibElementScanner elementScanner = new XlibElementScanner(environment);
            elementScanner.scan(environment.getSpecifiedElements(), null);
            this.serializeToYaml(elementScanner.getLibrary());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void serializeToYaml(Xlib xlib) throws IOException {
        this.outputFile.getParentFile().mkdirs();
        this.objectMapper.writeValue(this.outputFile, (Object)xlib);
    }

    private static ObjectMapper newObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    private Set<Doclet.Option> options() {
        return Set.of(new AbstractOption("-d", 1, "<directory>"){

            @Override
            public boolean process(String option, List<String> arguments) {
                XlibDoclet.this.outputFile = new File(arguments.get(0), XlibDoclet.FILENAME);
                return false;
            }
        }, new AbstractOption("-doctitle", 1, "<title>"){}, new AbstractOption("-notimestamp"){}, new AbstractOption("-windowtitle", 1, "<title>"){});
    }

    private static abstract class AbstractOption
    implements Doclet.Option {
        private final List<String> names;
        private final int argumentCount;
        private final String parameters;

        protected AbstractOption(String name) {
            this(name, 0, "");
        }

        protected AbstractOption(String name, int argumentCount, String parameters) {
            this.names = List.of(name);
            this.argumentCount = argumentCount;
            this.parameters = parameters;
        }

        @Override
        public int getArgumentCount() {
            return this.argumentCount;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getParameters() {
            return this.parameters;
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            return false;
        }
    }
}

