/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.tasks.test;

import ch.e2e.ant.gui.junit.E2ETestListener;
import ch.e2e.ant.tasks.test.JUnitTest;
import ch.e2e.ant.tasks.test.TestSuite;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.junit.TestUnit;
import ch.e2e.test.junit.TestcaseLoadErrorTest;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TestUnitTask
extends Task {
    private File[] testcases;
    private String name;
    private ArrayList<TestSuite> testSuites = new ArrayList();

    public void setTestcases(String testcases) {
        String[] testcaseArray = testcases.split("\\s");
        this.testcases = new File[testcaseArray.length];
        for (int i = 0; i < testcaseArray.length; ++i) {
            File testcaseFile = new File(testcaseArray[i]);
            if (!testcaseFile.isAbsolute()) {
                testcaseFile = new File(this.getProject().getBaseDir(), testcaseArray[i]);
            }
            this.testcases[i] = testcaseFile;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object createTestSuite() {
        TestSuite testSuite = new TestSuite(this.getProject().getBaseDir());
        this.testSuites.add(testSuite);
        return testSuite;
    }

    public void execute() throws BuildException {
        if (this.testSuites.size() == 0) {
            BuildException e = new BuildException("At least one testsuite element must be defined.");
            this.doLoadError(e);
            throw e;
        }
        try {
            JUnitTest test = new JUnitTest();
            TestUnit testUnit = new TestUnit();
            for (TestSuite testSuite : this.testSuites) {
                E2ETestSuite e2eTestSuite = new E2ETestSuite(testSuite.getTestcases(), testSuite.getLogfile());
                if (testSuite.getName() != null) {
                    e2eTestSuite.setName(testSuite.getName());
                }
                testUnit.addTestSuite(e2eTestSuite);
                e2eTestSuite.deleteLogfile();
            }
            test.doTest(testUnit);
        }
        catch (Throwable e) {
            this.doLoadError(e);
            throw new BuildException(e);
        }
    }

    private void doLoadError(Throwable e) {
        String name = "Could not load testcases. ";
        TestcaseLoadErrorTest test = new TestcaseLoadErrorTest(name);
        TestResult result = new TestResult();
        E2ETestListener testListener = E2ETestListener.getInstance();
        testListener.testStarting((TestUnit)test, result);
        testListener.testFailed((Test)test, e);
        testListener.showStatus("Error loading testcases", 0);
        testListener.testFinished((Test)test, result);
    }
}

