/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.tasks.test;

import ch.e2e.ant.gui.junit.E2ETestListener;
import ch.e2e.ant.tasks.test.JUnitTest;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.junit.TestUnit;
import ch.e2e.test.junit.TestcaseLoadErrorTest;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TestSuiteTask
extends Task {
    private File[] testcases;
    private String name;
    private TestLogfile logfile;

    public void setTestcases(String testcases) {
        String[] testcaseArray = testcases.split("\\s");
        this.testcases = new File[testcaseArray.length];
        for (int i = 0; i < testcaseArray.length; ++i) {
            File testcaseFile = new File(testcaseArray[i]);
            if (!testcaseFile.isAbsolute()) {
                testcaseFile = new File(this.getProject().getBaseDir(), testcaseArray[i]);
            }
            this.testcases[i] = testcaseFile;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestLogfile createLogfile() {
        this.logfile = new TestLogfile();
        return this.logfile;
    }

    public void execute() throws BuildException {
        if (this.testcases == null) {
            BuildException e = new BuildException("Attribute testcases must be defined.");
            this.doLoadError(e);
            throw e;
        }
        try {
            E2ETestSuite testSuite = new E2ETestSuite(this.testcases, this.logfile);
            if (this.name != null) {
                testSuite.setName(this.name);
            }
            testSuite.deleteLogfile();
            JUnitTest test = new JUnitTest();
            test.doTest((Test)testSuite);
        }
        catch (Throwable e) {
            this.doLoadError(e);
            throw new BuildException(e);
        }
    }

    private void doLoadError(Throwable e) {
        String name = "Could not load testcases. ";
        TestcaseLoadErrorTest test = new TestcaseLoadErrorTest(name);
        TestResult result = new TestResult();
        E2ETestListener testListener = E2ETestListener.getInstance();
        testListener.testStarting((TestUnit)test, result);
        testListener.testFailed((Test)test, e);
        testListener.showStatus("Error loading testcases", 0);
        testListener.testFinished((Test)test, result);
    }
}

