/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.PropertyFile;

public class RegexPropertyFile
extends PropertyFile {
    private File propertyfile;
    private ArrayList regexEntries = new ArrayList();

    public void execute() throws BuildException {
        if (this.propertyfile == null) {
            throw new BuildException("file token must not be null.", this.getLocation());
        }
        Properties properties = this.readFile();
        this.findMatchingEntries(properties);
        super.execute();
    }

    private void findMatchingEntries(Properties properties) {
        int length = this.regexEntries.size();
        for (int i = 0; i < length; ++i) {
            RegexEntry regexEntry = (RegexEntry)this.regexEntries.get(i);
            for (String string : properties.keySet()) {
                if (!Pattern.matches(regexEntry.key, string)) continue;
                this.createEntry(string, regexEntry);
            }
        }
    }

    private void createEntry(String key, RegexEntry regexEntry) {
        PropertyFile.Entry entry = this.createEntry();
        entry.setKey(key);
        entry.setValue(regexEntry.value);
        if (regexEntry.operation != null) {
            PropertyFile.Entry.Operation operation = new PropertyFile.Entry.Operation();
            operation.setValue(regexEntry.operation);
            entry.setOperation(operation);
        }
        entry.setDefault(regexEntry.defaultValue);
        entry.setPattern(regexEntry.pattern);
        if (regexEntry.type != null) {
            PropertyFile.Entry.Type type = new PropertyFile.Entry.Type();
            type.setValue(regexEntry.type);
            entry.setType(type);
        }
    }

    public RegexEntry createRegexEntry() {
        RegexEntry entry = new RegexEntry();
        this.regexEntries.add(entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readFile() throws BuildException {
        Properties properties;
        block9: {
            properties = new Properties();
            try {
                if (!this.propertyfile.exists()) break block9;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(this.propertyfile);
                    properties.load(fis);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString());
            }
        }
        return properties;
    }

    public void setFile(File file) {
        this.propertyfile = file;
        super.setFile(file);
    }

    public class RegexEntry {
        private String key;
        private String type;
        private String operation;
        private String value;
        private String defaultValue;
        private String pattern;

        public void setDefault(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

