/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.util.VersionChecker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;

public class CvsPackageList
extends AbstractCvsTask {
    private static String UPTODATE = "Up-to-date";
    private static String LOCALLY_MODIFIED = "Locally Modified";
    private boolean executing;
    private String property;

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("The attribute 'property' must be set.");
        }
        ArrayList oldFiles = this.createFileList();
        this.executing = true;
        this.setCommand("-Q status -q");
        this.setQuiet(false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setOutputStream(out);
        super.execute();
        this.parseOutput(out.toString());
        this.executing = false;
        ArrayList newFiles = this.createFileList();
        ArrayList changedPackages = this.compare(oldFiles, newFiles);
        String value = this.createPackageString(changedPackages);
        this.getProject().setProperty(this.property, value);
    }

    public void setCommand(String c) throws BuildException {
        if (!this.executing) {
            throw new BuildException("The attribute 'command' is fixed to 'status'");
        }
        super.setCommand(c);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    private ArrayList createFileList() {
        ArrayList files = new ArrayList();
        Object in = null;
        return files;
    }

    private ArrayList compare(ArrayList oldFiles, ArrayList newFiles) {
        int index;
        FileEntry fileEntry;
        int i;
        ArrayList<String> changedPackages = new ArrayList<String>();
        int length = newFiles.size();
        for (i = 0; i < length; ++i) {
            fileEntry = (FileEntry)newFiles.get(i);
            index = oldFiles.indexOf(fileEntry);
            if (index == -1) {
                if (changedPackages.contains(fileEntry.packageName)) continue;
                changedPackages.add(fileEntry.packageName);
                continue;
            }
            FileEntry oldEntry = (FileEntry)oldFiles.get(index);
            if (!VersionChecker.isNewer((String)oldEntry.version, (String)fileEntry.version) || changedPackages.contains(fileEntry.packageName)) continue;
            changedPackages.add(fileEntry.packageName);
        }
        length = oldFiles.size();
        for (i = 0; i < length; ++i) {
            fileEntry = (FileEntry)oldFiles.get(i);
            index = newFiles.indexOf(fileEntry);
            if (index != -1 || changedPackages.contains(fileEntry.packageName)) continue;
            changedPackages.add(fileEntry.packageName);
        }
        return changedPackages;
    }

    private String createPackageString(ArrayList packages) {
        StringBuffer s = new StringBuffer();
        int length = packages.size();
        for (int i = 0; i < length; ++i) {
            s.append((String)packages.get(i) + ' ');
        }
        return s.toString().trim();
    }

    private void parseOutput(String cvsout) {
        if (cvsout.length() > 0) {
            // empty if block
        }
    }

    private String getCvsRootWithoutServer() {
        String cvsRoot = this.getCvsRoot();
        int index = cvsRoot.lastIndexOf(58);
        if (index != -1) {
            cvsRoot = cvsRoot.substring(index + 1);
        }
        return cvsRoot.replace('\\', '/');
    }

    private String createDestRoot(String cvsRoot, String line, int index) {
        String dest;
        String entry;
        String start = line.substring(0, index);
        if (start.endsWith(":")) {
            cvsRoot = start.substring(start.length() - 2) + cvsRoot;
            index -= 2;
        }
        if ((entry = line.substring(index + cvsRoot.length(), line.length() - 2)).startsWith("/")) {
            entry = entry.substring(1);
        }
        if ((dest = this.getDest().getAbsolutePath().replace('\\', '/')).startsWith("/")) {
            dest = dest.substring(1);
        }
        while (!entry.startsWith(dest)) {
            index = dest.indexOf(47);
            dest = dest.substring(index + 1);
        }
        dest = (cvsRoot = cvsRoot.replace('\\', '/')).endsWith("/") ? cvsRoot + dest : cvsRoot + "/" + dest;
        if (!dest.endsWith("/")) {
            dest = dest + "/";
        }
        return dest;
    }

    private String checkLine(String line, String rootDest) {
        int index = line.indexOf(rootDest);
        if (index != -1) {
            String cvsentry = line.substring(index + rootDest.length(), line.length() - 2);
            if (cvsentry.charAt(0) == '/') {
                cvsentry = cvsentry.substring(1);
            }
            int dashIndex = line.indexOf(58);
            String version = line.substring(dashIndex + 1, index).trim();
            return cvsentry + ';' + version;
        }
        return null;
    }

    private class FileEntry {
        private String fullname;
        private String packageName;
        private String version;

        private FileEntry(String cvsentry) {
            int index = cvsentry.indexOf(59);
            this.fullname = cvsentry.substring(0, index);
            String filename = new File(this.fullname).getName();
            this.version = cvsentry.substring(index + 1);
            this.packageName = cvsentry.substring(0, index - filename.length() - 1);
        }

        public boolean equals(Object other) {
            return ((FileEntry)other).fullname.equals(this.fullname);
        }
    }
}

