/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.PoolConfig;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import java.util.Date;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class JMSConnectionAdapterFactory
extends BaseKeyedPoolableObjectFactory<JMSSessionParameter, ConnectionAdapter> {
    private PoolConfig sessionPoolConfig = new PoolConfig();

    public ConnectionAdapter makeObject(JMSSessionParameter sessionParameter) {
        long time = new Date().getTime();
        JMSLogger.getInstance().debug("13", "JMSConnectionAdapterFactory.makeObject: Creating and opening new connection.");
        ConnectionAdapter connection = new ConnectionAdapter(sessionParameter, this.sessionPoolConfig);
        JMSLogger.getInstance().debug("13", String.format("JMSConnectionAdapterFactory.makeObject: Opening connection [%s] took %sms.", connection, String.valueOf(new Date().getTime() - time)));
        return connection;
    }

    public boolean validateObject(JMSSessionParameter key, ConnectionAdapter obj) {
        return super.validateObject((Object)key, (Object)obj);
    }

    public void destroyObject(JMSSessionParameter key, ConnectionAdapter adapter) throws Exception {
        JMSLogger.getInstance().debug("19", String.format("JMSConnectionAdapterFactory.destroyObject: Destroying connection [%s].", adapter));
        adapter.close();
        super.destroyObject((Object)key, (Object)adapter);
    }

    public void setSessionPoolConfig(PoolConfig sessionPoolConfig) {
        this.sessionPoolConfig = sessionPoolConfig;
    }
}

