/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.jms.JMSInitialContext;
import ch.e2e.bridge.server.jms.parameter.JMSBytesMessage;
import ch.e2e.bridge.server.jms.parameter.JMSMessage;
import ch.e2e.bridge.server.jms.parameter.JMSTextMessage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;

public class JMSAddOnHelper {
    public static Destination getDestination(String destinationName, Session session, JMSInitialContext initialContext) throws JMSException, NamingException {
        Object destination = initialContext == null ? session.createQueue(destinationName) : (Destination)initialContext.lookup(destinationName);
        return destination;
    }

    public static void assignFrom(JMSMessage jmsMessage, Message message) throws JMSException {
        Enumeration names = message.getPropertyNames();
        HashMap<String, Object> stringProperties = new HashMap<String, Object>();
        HashMap<String, Object> longProperties = new HashMap<String, Object>();
        HashMap<String, Object> byteProperties = new HashMap<String, Object>();
        HashMap<String, Object> booleanProperties = new HashMap<String, Object>();
        HashMap<String, Object> doubleProperties = new HashMap<String, Object>();
        HashMap<String, Object> integerProperties = new HashMap<String, Object>();
        HashMap<String, Object> floatProperties = new HashMap<String, Object>();
        HashMap<String, Object> shortProperties = new HashMap<String, Object>();
        while (names.hasMoreElements()) {
            String propertyName = (String)names.nextElement();
            Object property = message.getObjectProperty(propertyName);
            if (property == null) {
                jmsMessage.getStringProperties().put(propertyName, null);
                continue;
            }
            if (property instanceof String) {
                stringProperties.put(propertyName, property);
                continue;
            }
            if (property instanceof Long) {
                longProperties.put(propertyName, property);
                continue;
            }
            if (property instanceof Byte) {
                byteProperties.put(propertyName, property);
                continue;
            }
            if (property instanceof Boolean) {
                booleanProperties.put(propertyName, property);
                continue;
            }
            if (property instanceof Double) {
                doubleProperties.put(propertyName, property);
                continue;
            }
            if (property instanceof Integer) {
                integerProperties.put(propertyName, property);
                continue;
            }
            if (property instanceof Float) {
                floatProperties.put(propertyName, property);
                continue;
            }
            if (!(property instanceof Short)) continue;
            shortProperties.put(propertyName, property);
        }
        jmsMessage.setStringProperties(stringProperties);
        jmsMessage.setLongProperties(longProperties);
        jmsMessage.setByteProperties(byteProperties);
        jmsMessage.setBooleanProperties(booleanProperties);
        jmsMessage.setDoubleProperties(doubleProperties);
        jmsMessage.setIntegerProperties(integerProperties);
        jmsMessage.setFloatProperties(floatProperties);
        jmsMessage.setShortProperties(shortProperties);
        jmsMessage.setJMSCorrelationID(message.getJMSCorrelationID());
        if (message.getJMSCorrelationID() != null) {
            jmsMessage.setJMSCorrelationIDAsBytes(message.getJMSCorrelationIDAsBytes());
        }
        jmsMessage.setJMSPersistentDeliveryMode(message.getJMSDeliveryMode() == 2);
        if (message.getJMSDestination() != null) {
            jmsMessage.setJmsDestination(message.getJMSDestination().toString());
        }
        jmsMessage.setJmsExpiration(message.getJMSExpiration());
        jmsMessage.setJmsMessageID(message.getJMSMessageID());
        jmsMessage.setJmsPriority(message.getJMSPriority());
        jmsMessage.setJMSRedelivered(message.getJMSRedelivered());
        if (message.getJMSReplyTo() != null) {
            jmsMessage.setJMSReplyTo(message.getJMSReplyTo().toString());
        }
        jmsMessage.setJMSTimestamp(message.getJMSTimestamp());
        jmsMessage.setJMSType(message.getJMSType());
    }

    public static void assign(JMSMessage jmsMessage, Session session, Message msg, JMSInitialContext initialContext) throws JMSException, NamingException {
        JMSAddOnHelper.setProperties(jmsMessage.getLongProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getByteProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getBooleanProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getDoubleProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getStringProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getIntegerProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getFloatProperties(), msg);
        JMSAddOnHelper.setProperties(jmsMessage.getShortProperties(), msg);
        msg.setJMSCorrelationID(jmsMessage.getJMSCorrelationID());
        if (jmsMessage.getJMSReplyTo() != null && !jmsMessage.getJMSReplyTo().equals("")) {
            Object destination = initialContext == null ? session.createQueue(jmsMessage.getJMSReplyTo()) : (Destination)initialContext.lookup(jmsMessage.getJMSReplyTo());
            msg.setJMSReplyTo((Destination)destination);
        }
        msg.setJMSType(jmsMessage.getJMSType());
    }

    private static void setProperties(Map longProperties, Message msg) throws JMSException {
        Iterator iterator = longProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry property = o = iterator.next();
            String propertyName = (String)property.getKey();
            msg.setObjectProperty(propertyName, property.getValue());
        }
    }

    public static void setBody(JMSTextMessage jmsTextMessage, Message msg) throws JMSException {
        String text = JMSAddOnHelper.getText(msg);
        if (text != null) {
            jmsTextMessage.setMessage(text);
        }
    }

    public static String getText(Message msg) throws JMSException {
        String text = null;
        if (msg instanceof TextMessage) {
            TextMessage txtMsg = (TextMessage)msg;
            text = txtMsg.getText();
        } else if (msg instanceof BytesMessage) {
            BytesMessage byteMessage = (BytesMessage)msg;
            long length = byteMessage.getBodyLength();
            byte[] bytes = new byte[(int)length];
            byteMessage.readBytes(bytes);
            text = new String(bytes);
        }
        return text;
    }

    public static void setBody(JMSBytesMessage jmsBytesMessage, Message msg) throws JMSException {
        byte[] bytes = JMSAddOnHelper.getBytes(msg);
        if (bytes != null) {
            jmsBytesMessage.setByteMessage(bytes);
        }
    }

    public static byte[] getBytes(Message msg) throws JMSException {
        byte[] bytes = null;
        if (msg instanceof BytesMessage) {
            BytesMessage byteMessage = (BytesMessage)msg;
            long length = byteMessage.getBodyLength();
            bytes = new byte[(int)length];
            byteMessage.readBytes(bytes);
        } else if (msg instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)msg;
            bytes = textMessage.getText().getBytes();
        }
        return bytes;
    }
}

