/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogAttribute;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.functors.ContainsPredicate;
import ch.e2e.functors.EqualPredicate;
import ch.e2e.functors.GreaterThanPredicate;
import ch.e2e.functors.LessThanPredicate;
import ch.e2e.util.CalendarUtilities;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.regex.Pattern;

public class TransactionLogEntry
extends TransactionLogObject {
    private static final String SEPARATOR = "\t";
    private static final Pattern PATTERN = Pattern.compile("\t");
    private final TransactionLog.Version version;
    private int lineNumber;
    private String transactionId;
    private String requestId;
    private State state;
    private String domain;
    private LogType logType;
    private AttributeMap attributes = new AttributeMap();
    private int index;

    public TransactionLogEntry(TransactionLog.Version version, String tabSeparatedLine, int lineNumber) {
        this.version = version;
        this.initialize(PATTERN.split(tabSeparatedLine, -1), lineNumber);
    }

    private void initialize(String[] values, int lineNumber) throws IllegalArgumentException {
        if (values.length != this.version.getColumns()) {
            throw new IllegalArgumentException("Wrong number of arguments in line " + lineNumber);
        }
        this.lineNumber = lineNumber;
        try {
            this.createAttribute(Attribute.DATE, CalendarUtilities.parseISO8601((String)(values[0] + "T" + values[1] + values[2])));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage() + " in line " + lineNumber);
        }
        this.requestId = values[4];
        this.createAttribute(Attribute.COMPONENT_NAME, values[5].startsWith("urn:") ? values[5].substring(4) : values[5]);
        this.createAttribute(Attribute.ELAPSED_TIME, Integer.valueOf(values[6]));
        this.state = State.valueOf(values[7]);
        this.domain = values[8];
        this.logType = LogType.valueOf(values[9]);
        this.createAttribute(Attribute.PARAM_1, values[10].length() == 0 ? null : values[10]);
        this.createAttribute(Attribute.PARAM_2, values[11].length() == 0 ? null : values[11]);
        if (values[3].length() != 0) {
            this.transactionId = values[3];
        }
        switch (this.version) {
            case Version_0: {
                break;
            }
            case Version_1: {
                this.createAttribute(Attribute.CORRELATION_ID, values[12].length() == 0 ? null : values[12]);
            }
        }
    }

    public String getKey() {
        String key = null;
        if (this.isServiceEnter() || this.isServiceExit()) {
            key = this.getFullRequestId() + ":" + this.getComponentName();
        } else if (this.isPState() && this.isIOExit()) {
            key = this.getFullRequestId() + ":" + this.getComponentName() + ":" + this.getParam_2();
        }
        return key;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getId() {
        return String.valueOf(this.lineNumber);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public TransactionLogAttribute<?> getAttribute(Attribute attribute) {
        return (TransactionLogAttribute)this.attributes.get((Object)attribute);
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public Object getAttributeValue(Attribute attribute) {
        return this.getAttribute(attribute).getValue();
    }

    @Override
    public String getName() {
        String name = "";
        String param_1 = this.getParam_1();
        switch (this.getLogType()) {
            case IO_ENTER: 
            case IO_EXIT: {
                name = param_1.equals("\"\"") ? this.getComponentName() : param_1;
                break;
            }
            case SERVICE_ENTER: 
            case SERVICE_EXIT: {
                name = this.getOperation();
                break;
            }
            case TRANSITION_ENTER: 
            case TRANSITION_EXIT: {
                int index = param_1.indexOf("...");
                name = (index == -1 ? param_1 : param_1.substring(0, index)) + ", " + this.getParam_2();
                break;
            }
            case DOACTION_ENTRY: 
            case DOACTION_EXIT: {
                int index = param_1.indexOf("...");
                name = "do / " + (index == -1 ? param_1 : param_1.substring(0, index));
                break;
            }
            case CUSTOM: {
                name = this.getComponentName();
            }
        }
        return name;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getFullRequestId() {
        return this.getParent().getId();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getComponentName() {
        return (String)((TransactionLogAttribute)this.attributes.get((Object)Attribute.COMPONENT_NAME)).getValue();
    }

    public Date getDate() {
        return (Date)((TransactionLogAttribute)this.attributes.get((Object)Attribute.DATE)).getValue();
    }

    public String getDomain() {
        return this.domain;
    }

    public int getElapsedTime() {
        return (Integer)((TransactionLogAttribute)this.attributes.get((Object)Attribute.ELAPSED_TIME)).getValue();
    }

    public LogType getLogType() {
        return this.logType;
    }

    public boolean hasLogType(LogType logType) {
        return this.getLogType().equals((Object)logType);
    }

    public boolean hasState(State state) {
        return this.getState().equals((Object)state);
    }

    public String getParam_1() {
        return (String)((TransactionLogAttribute)this.attributes.get((Object)Attribute.PARAM_1)).getValue();
    }

    public String getParam_2() {
        return (String)((TransactionLogAttribute)this.attributes.get((Object)Attribute.PARAM_2)).getValue();
    }

    public String getCorrelationId() {
        return this.version != TransactionLog.Version.Version_0 ? (String)((TransactionLogAttribute)this.attributes.get((Object)Attribute.CORRELATION_ID)).getValue() : null;
    }

    public State getState() {
        return this.state;
    }

    public int getDuration() {
        TransactionLogAttribute attribute = (TransactionLogAttribute)this.attributes.get((Object)Attribute.DURATION);
        Integer d = attribute == null ? null : (Integer)attribute.getValue();
        return d == null ? -1 : d;
    }

    public void setDuration(int duration) {
        if (duration > -1) {
            this.createAttribute(Attribute.DURATION, duration);
        }
    }

    public boolean isInterface() {
        return this.domain.equalsIgnoreCase("INTERFACE");
    }

    public boolean isPState() {
        return this.domain.equalsIgnoreCase("PSTATE");
    }

    public boolean isBackend() {
        return !this.isInterface() && !this.isPState() && !this.isCustom();
    }

    public boolean isStartEntry() {
        return this.isServiceEnter() || this.isTransitionEnter();
    }

    public boolean isServiceEnter() {
        return this.hasLogType(LogType.SERVICE_ENTER);
    }

    public boolean isServiceExit() {
        return this.hasLogType(LogType.SERVICE_EXIT);
    }

    public boolean isTransitionEnter() {
        return this.hasLogType(LogType.TRANSITION_ENTER);
    }

    public boolean isTransitionExit() {
        return this.hasLogType(LogType.TRANSITION_EXIT);
    }

    public boolean isIOEnter() {
        return this.hasLogType(LogType.IO_ENTER);
    }

    public boolean isIOExit() {
        return this.hasLogType(LogType.IO_EXIT);
    }

    public boolean isDoActionEnter() {
        return this.hasLogType(LogType.DOACTION_ENTRY);
    }

    public boolean isDoActionExit() {
        return this.hasLogType(LogType.DOACTION_EXIT);
    }

    public boolean isCustom() {
        return this.hasLogType(LogType.CUSTOM);
    }

    public String getOperation() {
        String name = this.getComponentName();
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(index + 1);
    }

    @Override
    public Object getChild(int index) {
        Object result = null;
        if (index > -1 && index < this.attributes.size()) {
            Iterator iterator = this.attributes.values().iterator();
            for (int i = 0; i < index; ++i) {
                iterator.next();
            }
            result = iterator.next();
        }
        return result == null ? null : result;
    }

    @Override
    public int getChildCount() {
        return this.attributes.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        int index = -1;
        Iterator iterator = this.attributes.values().iterator();
        int i = 0;
        while (index == -1 && iterator.hasNext()) {
            if (((TransactionLogAttribute)iterator.next()).equals(child)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    @Override
    public int getType() {
        int type = 5;
        switch (this.getLogType()) {
            case IO_ENTER: 
            case SERVICE_ENTER: 
            case TRANSITION_ENTER: 
            case DOACTION_ENTRY: {
                type = this.getState() == State.OK ? 6 : 7;
                break;
            }
            case IO_EXIT: 
            case SERVICE_EXIT: 
            case TRANSITION_EXIT: 
            case DOACTION_EXIT: {
                type = this.getState() == State.OK ? 8 : 9;
                break;
            }
            case CUSTOM: {
                type = 11;
            }
        }
        return type;
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void delete() {
    }

    private <T> void createAttribute(Attribute name, T value) {
        TransactionLogAttribute<T> attribute = new TransactionLogAttribute<T>(name.toString(), value);
        attribute.setParent(this);
        this.attributes.put(name, attribute);
    }

    public static enum LogType {
        SERVICE_ENTER,
        SERVICE_EXIT,
        TRANSITION_ENTER,
        TRANSITION_EXIT,
        IO_ENTER,
        IO_EXIT,
        DOACTION_ENTRY,
        DOACTION_EXIT,
        CUSTOM;

    }

    public static enum State {
        OK,
        ERROR;

    }

    public static enum Operation {
        EQUALS("=", EqualPredicate.class),
        LESS_THAN("<", LessThanPredicate.class),
        GREATER_THAN(">", GreaterThanPredicate.class),
        CONTAINS("~", ContainsPredicate.class);

        private final String name;
        private final Class<?> predicateClass;

        public String getName() {
            return this.name;
        }

        public Class<?> getPredicateClass() {
            return this.predicateClass;
        }

        public String toString() {
            return this.getName();
        }

        private Operation(String name, Class<?> predicateClass) {
            this.name = name;
            this.predicateClass = predicateClass;
        }
    }

    public static enum Attribute {
        DATE("Date", Date.class),
        COMPONENT_NAME("Component Name", String.class),
        ELAPSED_TIME("Elapsed Time", Integer.class),
        DURATION("Duration", Integer.class),
        PARAM_1("Param 1", String.class),
        PARAM_2("Param 2", String.class),
        CORRELATION_ID("Correlation ID", String.class);

        private final String name;
        private final Class<?> type;

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return this.getName();
        }

        private Attribute(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class AttributeMap
    extends EnumMap<Attribute, TransactionLogAttribute<?>> {
        public AttributeMap() {
            super(Attribute.class);
        }

        public Object getValue(Attribute attribute) {
            return ((TransactionLogAttribute)this.get((Object)attribute)).getValue();
        }

        public Class<?> getValueClass(Attribute attribute) {
            return ((TransactionLogAttribute)this.get((Object)attribute)).getValueClass();
        }
    }
}

