/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.response.ResponseParser;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.request.Request;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Trace
extends Testcase {
    public Trace(File home) {
        super(home.getName(), home, 39);
        this.status = 39;
        if (this.getResponseFile().exists()) {
            this.loadUmlTreeFromDisk();
        }
    }

    public void setResponse(Document document) {
        this.getTraceFolder().mkdirs();
        try {
            DomUtilities.serialize((File)this.getResponseLog().getLogFile(), (Document)document, (boolean)true);
            ResponseParser responseParser = new ResponseParser(document, this);
            this.setUmlTree(responseParser.getUmlTree());
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setResponse", e);
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void saveRequest() {
    }

    public Request getRequest() {
        return null;
    }

    public String getRequestData() {
        return null;
    }

    public long requestLastModified() {
        return 0L;
    }

    public String getResponseData() {
        return null;
    }

    public long responseLastModified() {
        return 0L;
    }

    protected void createDefaultProperties() {
    }

    protected void saveProperties() {
    }

    public boolean isRPCEncoding() {
        return true;
    }

    public String getLocation() {
        return null;
    }

    public boolean loadUmlTreeFromDisk() {
        boolean loaded = false;
        this.setUmlTree(null);
        try {
            Document document = DomUtilities.parse((File)this.getResponseFile(), (boolean)false, (boolean)false, (boolean)true);
            this.setUmlTree(new UmlTree(document.getDocumentElement(), this.getTraceFolder()));
            loaded = this.getUmlTree() != null;
        }
        catch (ParserConfigurationException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(((Object)((Object)this)).getClass().getName(), "loadUmlTree", e);
        }
        catch (SAXException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(((Object)((Object)this)).getClass().getName(), "loadUmlTree", e);
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(((Object)((Object)this)).getClass().getName(), "loadUmlTree", e);
        }
        return loaded;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Trace && this.getName().equals(((Trace)((Object)obj)).getName());
    }

    public void clear() {
        this.removeInspectionListeners();
        this.setUmlTree(null);
    }

    public void delete() throws FilesNotDeletedException {
        ArrayList undeletedFiles = new ArrayList();
        try {
            this.clearResultObjects();
        }
        catch (FilesNotDeletedException e) {
            undeletedFiles.addAll(e.getFiles());
        }
        this.clear();
        try {
            FileUtilities.deleteDirectory((File)this.home);
        }
        catch (FilesNotDeletedException e) {
            undeletedFiles.addAll(e.getFiles());
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }
}

