/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.Utf8CPInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;

public final class ClassFile {
    private MethodInfo[] methods;
    private String sourceFile;
    private String fullname;
    private int access_flags;

    public ClassFile(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        ConstantPool constantPool = new ConstantPool();
        dis.readInt();
        dis.readShort();
        dis.readShort();
        constantPool.read(dis);
        constantPool.resolve();
        this.access_flags = dis.readShort();
        short this_class = dis.readShort();
        this.fullname = ((ClassCPInfo)constantPool.getEntry(this_class)).getClassName().replace('/', '.');
        dis.readShort();
        short count = dis.readShort();
        dis.skipBytes(count * 2);
        int numFields = dis.readShort();
        int i = 0;
        while (i < numFields) {
            dis.skip(6L);
            int attributes_count = dis.readUnsignedShort();
            int j = 0;
            while (j < attributes_count) {
                dis.skipBytes(2);
                int len = dis.readInt();
                dis.skipBytes(len);
                ++j;
            }
            ++i;
        }
        int method_count = dis.readShort();
        this.methods = new MethodInfo[method_count];
        int i2 = 0;
        while (i2 < method_count) {
            this.methods[i2] = new MethodInfo();
            this.methods[i2].read(constantPool, dis);
            ++i2;
        }
        int attributes_count = dis.readUnsignedShort();
        int j = 0;
        while (j < attributes_count) {
            short attr_id = dis.readShort();
            int len = dis.readInt();
            String attr_name = Utils.getUTF8Value(constantPool, attr_id);
            if ("SourceFile".equals(attr_name)) {
                short name_index = dis.readShort();
                this.sourceFile = ((Utf8CPInfo)constantPool.getEntry(name_index)).getValue();
            } else {
                dis.skipBytes(len);
            }
            ++j;
        }
    }

    public int getAccess() {
        return this.access_flags;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public String getFullName() {
        return this.fullname;
    }

    public String getName() {
        String name = this.getFullName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(pos + 1);
    }

    public String getPackage() {
        String name = this.getFullName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(0, pos);
    }
}

