/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.script.ScriptDef;

public class ScriptDefBase
extends Task
implements DynamicConfigurator {
    private Map nestedElementMap = new HashMap();
    private Map attributes = new HashMap();

    public void execute() {
        this.getScript().executeScript(this.attributes, this.nestedElementMap);
    }

    private ScriptDef getScript() {
        String name = this.getTaskType();
        Map scriptRepository = (Map)this.getProject().getReference("org.apache.ant.scriptrepo");
        if (scriptRepository == null) {
            throw new BuildException("Script repository not found for " + name);
        }
        ScriptDef definition = (ScriptDef)scriptRepository.get(this.getTaskType());
        if (definition == null) {
            throw new BuildException("Script definition not found for " + name);
        }
        return definition;
    }

    public Object createDynamicElement(String name) {
        ArrayList<Object> nestedElementList = (ArrayList<Object>)this.nestedElementMap.get(name);
        if (nestedElementList == null) {
            nestedElementList = new ArrayList<Object>();
            this.nestedElementMap.put(name, nestedElementList);
        }
        Object element = this.getScript().createNestedElement(name);
        nestedElementList.add(element);
        return element;
    }

    public void setDynamicAttribute(String name, String value) {
        ScriptDef definition = this.getScript();
        if (!definition.isAttributeSupported(name)) {
            throw new BuildException("<" + this.getTaskType() + "> does not support the \"" + name + "\" attribute");
        }
        this.attributes.put(name, value);
    }
}

