/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.secure;

import ch.e2e.secure.Logging;
import ch.e2e.secure.VerifyQuestion;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class UntrustedHostnameVerifier
implements HostnameVerifier,
Logging {
    private VerifyQuestion question;

    public void setQuestion(VerifyQuestion question) {
        this.question = question;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean result = true;
        String peername = session.getPeerHost();
        try {
            logger.fine("hostname = " + hostname);
            logger.fine("peer ip = " + session.getPeerHost());
            peername = InetAddress.getByName(session.getPeerHost()).getCanonicalHostName().toLowerCase();
            logger.fine("peer name = " + peername);
        }
        catch (UnknownHostException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            peername = session.getPeerHost();
        }
        if (peername == null || !peername.equals(hostname)) {
            result = this.question.verify(hostname, peername);
        }
        return result;
    }
}

