/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.logging;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

class MaxLinesDocumentFilter
extends DocumentFilter {
    private final int maxLines;
    private final int freeLines;
    private int lines = 1;

    MaxLinesDocumentFilter(int maxLines) {
        this(maxLines, maxLines / 10);
    }

    MaxLinesDocumentFilter(int maxLines, int freeLines) {
        this.maxLines = maxLines;
        this.freeLines = freeLines;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        int newLines = MaxLinesDocumentFilter.numberOfLines(string);
        if (this.isReplaceCompletely(newLines)) {
            this.replaceCompletely(fb, string, newLines, attr);
        } else if (this.isReplacePartially(newLines)) {
            this.replacePartially(fb, string, newLines, attr);
        } else {
            this.insert(fb, string, newLines, attr);
        }
    }

    private boolean isReplaceCompletely(int newLines) {
        return newLines > this.maxLines - this.freeLines;
    }

    private void replaceCompletely(DocumentFilter.FilterBypass fb, String string, int newLines, AttributeSet attr) throws BadLocationException {
        super.replace(fb, 0, fb.getDocument().getLength(), MaxLinesDocumentFilter.removeLeadingLines(string, newLines + this.freeLines - this.maxLines), attr);
        this.lines = this.maxLines - this.freeLines;
    }

    private boolean isReplacePartially(int newLines) {
        return this.lines + newLines > this.maxLines;
    }

    private void replacePartially(DocumentFilter.FilterBypass fb, String string, int newLines, AttributeSet attr) throws BadLocationException {
        super.remove(fb, 0, MaxLinesDocumentFilter.offsetOfLine(fb.getDocument().getText(0, fb.getDocument().getLength()), newLines + this.lines + this.freeLines - this.maxLines - 1));
        super.insertString(fb, fb.getDocument().getLength(), string, attr);
        this.lines = this.maxLines - this.freeLines;
    }

    private void insert(DocumentFilter.FilterBypass fb, String string, int newLines, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, fb.getDocument().getLength(), string, attr);
        this.lines += newLines - 1;
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        throw new UnsupportedOperationException();
    }

    private static String removeLeadingLines(String text, int n) {
        return text.substring(MaxLinesDocumentFilter.offsetOfLine(text, n));
    }

    static int offsetOfLine(String text, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Line number out of bounds: " + n);
        }
        int i = n;
        int pos = 0;
        while (i-- > 0 && (pos = text.indexOf(10, pos) + 1) != 0) {
        }
        if (i < 0) {
            return pos;
        }
        throw new IndexOutOfBoundsException("Line number out of bounds: " + n);
    }

    static int numberOfLines(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int lines = 1;
        int pos = 0;
        while ((pos = s.indexOf(10, pos) + 1) != 0) {
            ++lines;
        }
        return lines;
    }
}

