/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.io.File;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class State
extends UmlObject {
    private static final Pattern PREFIXES_TO_REMOVE = Pattern.compile("^(\\QINSIDE \\E|\\QOUTSIDE \\E)");
    private Type stateType;

    public State(Element element, File documentFolder) {
        super(element, documentFolder);
        this.setStateType(element);
        this.name = PREFIXES_TO_REMOVE.matcher(this.name).replaceFirst("");
    }

    public State(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.setStateType(element);
        this.name = PREFIXES_TO_REMOVE.matcher(this.name).replaceFirst("");
    }

    @Override
    public int internalGetType() {
        return 10024 + this.getSubType();
    }

    public Type getStateType() {
        return this.stateType;
    }

    private void setStateType(Element element) {
        try {
            this.stateType = Type.valueOf(element.getTextContent());
        }
        catch (IllegalArgumentException e) {
            this.stateType = Type.STATE;
        }
    }

    private int getSubType() {
        return this.stateType.internalRepresentation;
    }

    public static enum Type {
        STATE(0),
        CHOICE(1),
        COMPOSITE(2),
        ENTRY(3),
        EXIT(4),
        FINAL(5),
        FORK(6),
        HISTORY(22),
        INITIAL(7),
        JOIN(8),
        ORTHOGONAL(9),
        SUBMACHINE(10),
        TERMINATE(11);

        private int internalRepresentation;

        private Type(int internalRepresentation) {
            this.internalRepresentation = internalRepresentation;
        }
    }
}

