/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.trace.testcase.Logging;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tools.TraceTools;
import ch.e2e.io.FilesNotDeletedException;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

public abstract class TestcaseRoot
extends TestcaseContainer
implements Logging {
    protected static XmlFileFilter xmlFileFitler = new XmlFileFilter();
    protected static TestcasePropertiesFilter testcasePropertiesFilter = new TestcasePropertiesFilter();
    private File home;

    public TestcaseRoot() {
        this("ROOT");
    }

    public TestcaseRoot(String name) {
        super(name, 1);
    }

    public Map<String, String> getWSDLFolderIds() {
        HashMap<String, String> ids;
        File wsdlIds = new File(this.home, ".wsdl.folder.ids");
        if (wsdlIds.exists()) {
            try {
                ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
            }
            catch (WrongIDFileVersionException e) {
                ids = new HashMap();
            }
        } else {
            ids = new HashMap<String, String>();
        }
        return ids;
    }

    public void saveWSDLFolderIds(Map<String, String> ids) {
        UniqueIdService.saveIds(ids, (File)new File(this.home, ".wsdl.folder.ids"));
    }

    public String createId(String name, File home) {
        HashMap<String, String> ids;
        File wsdlIds = new File(home, ".wsdl.folder.ids");
        if (wsdlIds.exists()) {
            try {
                ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
            }
            catch (WrongIDFileVersionException e) {
                ids = new HashMap();
            }
        } else {
            ids = new HashMap<String, String>();
        }
        String id = this.findNewId(name, ids);
        UniqueIdService.saveIds(ids, (File)wsdlIds);
        return id;
    }

    public String findNewId(String name, Map<String, String> ids) {
        return UniqueIdService.createUniqueId((String)name, (String)TraceTools.createPrefix(name), ids);
    }

    public abstract void projectChanged(E2EBuilderProject var1);

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    @Override
    public void delete(TestcaseObject child) throws FilesNotDeletedException {
        this.getChildren().remove(child.getName());
        child.delete();
        Map<String, String> ids = this.getWSDLFolderIds();
        ids.remove(child.getName());
        this.saveWSDLFolderIds(ids);
    }

    @Override
    public int hashCode() {
        return this.home == null ? super.hashCode() : this.home.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof TestcaseRoot && this.home != null && ((TestcaseRoot)obj).home != null) {
            result = this.home.equals(((TestcaseRoot)obj).home);
        }
        return result;
    }

    public final void projectOpened(E2EBuilderProject project) {
        this.home = new File(project.getProjectHome(), "testcase");
        this.projectChanged(project);
    }

    private static class TestcasePropertiesFilter
    implements FileFilter {
        private TestcasePropertiesFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().equals("testcase.properties");
        }
    }

    private static class XmlFileFilter
    implements FileFilter {
        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".xml");
        }
    }
}

