/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tools;

import ch.e2e.builder.traceviewer.tools.Logging;
import ch.e2e.builder.traceviewer.xsltinterface.XSLTInput;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TraceViewerTransformer {
    public static final String XML_line = "line";
    private static TraceViewerTransformer instance = new TraceViewerTransformer();
    private TransformerLoader transformerLoader;
    private String xmlpath;
    private HashMap<String, Transformer> transformers;
    private ErrorListener errorListener;

    private TraceViewerTransformer() {
        try {
            this.xmlpath = System.getProperty("ch.e2e.builder.traceviewer.xmlpath");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.transformerLoader = new TransformerLoader(this.xmlpath, this.getClass().getClassLoader());
        this.transformers = new HashMap();
        this.errorListener = new TransformerErrorListener();
    }

    public static TraceViewerTransformer getInstance() {
        return instance;
    }

    public String transformScript(String script, Reader source, Map<String, String> parameterMap) throws TransformerException, IOException, TransformerLoadException {
        Transformer transformer = this.getTransformer(script);
        StreamSource domSource = new StreamSource(source);
        XSLTInput.setParameter(parameterMap);
        DOMResult documentResult = new DOMResult();
        transformer.transform(domSource, documentResult);
        StringBuffer result = new StringBuffer();
        NodeList lines = ((Document)documentResult.getNode()).getDocumentElement().getElementsByTagName(XML_line);
        int length = lines.getLength();
        for (int i = 0; i < length; ++i) {
            Element line = (Element)lines.item(i);
            if (line.getFirstChild() == null) continue;
            result.append(line.getFirstChild().getNodeValue()).append("\n");
        }
        return result.toString();
    }

    private Transformer getTransformer(String script) throws TransformerLoadException {
        Transformer transformer = this.transformers.get(script);
        if (transformer == null) {
            transformer = this.transformerLoader.getTransformer(script);
            transformer.setErrorListener(this.errorListener);
            if (this.xmlpath == null) {
                this.transformers.put(script, transformer);
            }
        }
        return transformer;
    }

    private class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException e) {
            Logging.logger.warning("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "warning", e);
        }

        @Override
        public void error(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "error", e);
        }

        @Override
        public void fatalError(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "fatalError", e);
        }
    }
}

