/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.base.util.DateTimeUtil;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.Logging;
import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;

public class Identifier
implements Comparable<Identifier>,
Logging {
    private AbstractAsyncTestcaseFolder parent;
    private String classifier;
    private String identifier;
    private Instant firstEntry;
    private Instant lastEntry;
    private String displayName;
    private String location;
    private List<String> primaryKeyValues;

    public Identifier(AbstractAsyncTestcaseFolder parent, Object identifierNode) {
        this.parent = parent;
        this.location = parent.getLocation();
        XPath xPath = DomUtilities.newXPath();
        try {
            this.classifier = xPath.evaluate("Classifier", identifierNode);
            this.identifier = xPath.evaluate("Identifier", identifierNode);
            this.firstEntry = DateTimeUtil.toInstant((String)xPath.evaluate("FirstEntry", identifierNode));
            this.lastEntry = DateTimeUtil.toInstant((String)xPath.evaluate("LastEntry", identifierNode));
            this.displayName = xPath.evaluate("DisplayName", identifierNode);
            this.setPrimaryKeyValues(this.displayName);
        }
        catch (XPathExpressionException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "<init>", e);
        }
    }

    public Identifier(AbstractAsyncTestcaseFolder parent, Properties properties) {
        this(parent, properties.getProperty("classifier"), properties.getProperty("identifier"), DateTimeUtil.toInstant((String)properties.getProperty("first.entry")), DateTimeUtil.toInstant((String)properties.getProperty("last.entry")), properties.getProperty("displayname"), properties.getProperty("location"));
    }

    private Identifier(AbstractAsyncTestcaseFolder parent, String classifier, String identifier, Instant firstEntry, Instant lastEntry, String displayName, String location) {
        this.parent = parent;
        this.classifier = classifier;
        this.identifier = identifier;
        this.firstEntry = firstEntry;
        this.lastEntry = lastEntry;
        this.displayName = displayName;
        this.location = location;
        this.setPrimaryKeyValues(displayName);
    }

    public static Identifier createDummyIdentifier(AbstractAsyncTestcaseFolder parent) {
        Instant now = Instant.now();
        return new Identifier(parent, "dummy", "dummy", now, now, UUID.randomUUID().toString(), "response.log");
    }

    public AbstractAsyncTestcaseFolder getParent() {
        return this.parent;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Instant getLastEntry() {
        return this.lastEntry;
    }

    public Instant getFirstEntry() {
        return this.firstEntry;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLocation() {
        return this.location;
    }

    public List<String> getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public String toString() {
        return String.format("%s [%s]", this.displayName == null || this.displayName.isEmpty() ? this.lastEntry : this.displayName, this.location);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + (this.firstEntry != null ? this.firstEntry.hashCode() : 0);
        result = 31 * result + (this.lastEntry != null ? this.lastEntry.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.identifier.equals(that.identifier) && Objects.equals(this.firstEntry, that.firstEntry) && Objects.equals(this.lastEntry, that.lastEntry);
    }

    @Override
    public int compareTo(Identifier other) {
        int result;
        if (this.lastEntry == null) {
            result = other.lastEntry == null ? 0 : 1;
        } else if (other.lastEntry == null) {
            result = -1;
        } else {
            result = other.lastEntry.compareTo(this.lastEntry);
            if (result == 0) {
                result = this.firstEntry == null ? (other.firstEntry == null ? 0 : 1) : (other.firstEntry == null ? -1 : this.firstEntry.compareTo(other.firstEntry));
            }
        }
        return result;
    }

    private void setPrimaryKeyValues(String valuesAsString) {
        if (valuesAsString != null) {
            StringBuilder result = new StringBuilder();
            boolean escape = false;
            this.primaryKeyValues = new ArrayList<String>();
            block4: for (char c : valuesAsString.toCharArray()) {
                switch (c) {
                    case '\\': {
                        boolean bl = escape = !escape;
                        if (escape) continue block4;
                        result.append(c);
                        continue block4;
                    }
                    case ',': {
                        if (escape) {
                            result.append(c);
                            escape = false;
                            continue block4;
                        }
                        this.primaryKeyValues.add(result.toString());
                        result.setLength(0);
                        continue block4;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            this.primaryKeyValues.add(result.toString());
        }
    }
}

