/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.base.util.DateTimeUtil;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.response.AbstractResponseParser;
import ch.e2e.builder.trace.testcase.uml.UmlObjectWithDiagram;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.Identifier;
import ch.e2e.builder.traceviewer.testcase.response.ResponseParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Instant;

public abstract class AbstractAsynchronousTestcase
extends ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase
implements UmlObjectWithDiagram {
    private final Identifier identifier;

    public AbstractAsynchronousTestcase(File home, Identifier identifier, int type) {
        super(home, type);
        this.identifier = identifier;
    }

    public AbstractAsynchronousTestcase(File home, int type) throws FileNotFoundException {
        super(home, type);
        File propertiesFile = new File(home, this.getName() + ".testcase");
        if (!propertiesFile.exists()) {
            throw new FileNotFoundException();
        }
        this.identifier = new Identifier((AbstractAsyncTestcaseFolder)this.getParent(), this.getProperties());
    }

    public String getLocation() {
        return ((AbstractAsyncTestcaseFolder)this.getParent()).getLocation();
    }

    private String getSystemLocation() {
        return ((AbstractAsyncTestcaseFolder)this.getParent()).getSystemLocation();
    }

    protected AbstractResponseParser getResponseParser() {
        return new ResponseParser();
    }

    protected void saveProperties() {
        if (this.identifier != null) {
            this.setProperty("classifier", this.identifier.getClassifier());
            this.setProperty("identifier", this.identifier.getIdentifier());
            this.setProperty("first.entry", this.identifier.getFirstEntry().toString());
            this.setProperty("last.entry", this.identifier.getLastEntry().toString());
            this.setProperty("displayname", this.identifier.getDisplayName());
            this.setProperty("location", this.identifier.getLocation());
        }
        super.saveProperties();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        String name;
        if (this.identifier.getDisplayName() == null || this.identifier.getDisplayName().isEmpty()) {
            name = DateTimeUtil.formatLocalDateTime((Instant)this.identifier.getLastEntry());
        } else {
            String classifier = this.identifier.getClassifier();
            int idx = classifier.lastIndexOf(46);
            name = (idx == -1 ? classifier : classifier.substring(idx + 1)) + " (" + this.identifier.getDisplayName() + ")";
        }
        return this.getSystemLocation().equals(this.identifier.getLocation()) ? name : name + " [" + this.identifier.getLocation() + "]";
    }

    public int compareTo(Object o) {
        if (!(o instanceof AbstractAsynchronousTestcase)) {
            throw new ClassCastException("o has to be an instance of " + ((Object)((Object)this)).getClass());
        }
        return this.getIdentifier().compareTo(((AbstractAsynchronousTestcase)((Object)o)).getIdentifier());
    }

    public boolean hasDiagram() {
        return true;
    }

    public static class Key
    extends TestcaseObject {
        private final String name;
        private final String value;

        public Key(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Key(String name) {
            this(name, null);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + " = " + this.value;
        }

        public boolean isLeaf() {
            return true;
        }

        public Object getChild(int index) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public int getIndexOfChild(Object child) {
            return 0;
        }

        public int getType() {
            return 41;
        }

        protected void clear() {
        }

        protected void delete() {
        }
    }
}

