/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.traceviewer.execute.AsynchronousRequest;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import java.util.Collection;
import org.w3c.dom.Element;

public class SetConfigurationRequest
extends AsynchronousRequest {
    private static final String ACTION = "setConfiguration";
    private final Collection<String> inspectionIds;
    private AbstractAsyncTestcaseFolder testcaseFolder;
    private TraceSettings.TraceLevel traceLevel;
    private int traceMaxSize;

    public SetConfigurationRequest(AbstractAsyncTestcaseFolder testcaseFolder, TraceSettings.TraceLevel traceLevel, int maxSize, Collection<String> inspectionIds) {
        super(ACTION, testcaseFolder.getClassifier(), testcaseFolder.getCredentials());
        Element traceLevelElement = this.getRequest().createElement("traceLevel");
        traceLevelElement.appendChild(this.getRequest().createTextNode(traceLevel.toString()));
        this.getRequest().getDocumentElement().appendChild(traceLevelElement);
        Element maxSizeElement = this.getRequest().createElement("maxSize");
        maxSizeElement.appendChild(this.getRequest().createTextNode(String.valueOf(maxSize)));
        this.getRequest().getDocumentElement().appendChild(maxSizeElement);
        if (inspectionIds != null && !inspectionIds.isEmpty()) {
            Element inspectionListElement = this.getRequest().createElement("InspectionList");
            for (String inspectionId : inspectionIds) {
                Element activityElement = this.getRequest().createElement("Activity");
                activityElement.setTextContent(inspectionId);
                inspectionListElement.appendChild(activityElement);
            }
            this.getRequest().getDocumentElement().appendChild(inspectionListElement);
        }
        this.testcaseFolder = testcaseFolder;
        this.traceLevel = traceLevel;
        this.traceMaxSize = maxSize;
        this.inspectionIds = inspectionIds;
    }

    public SetConfigurationRequest(AbstractAsyncTestcaseFolder testcaseFolder) {
        this(testcaseFolder, testcaseFolder.getProposedTraceLevel(), testcaseFolder.getProposedTraceMaxSize(), testcaseFolder.getProposedInspectionIds());
    }

    public String getLocation() {
        return this.testcaseFolder.getLocation();
    }

    @Override
    public AbstractAsyncTestcaseFolder getSource() {
        return this.testcaseFolder;
    }

    public int getTraceMaxSize() {
        return this.traceMaxSize;
    }

    public TraceSettings.TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public Collection<String> getInspectionIds() {
        return this.inspectionIds;
    }
}

