/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.E2ETask;
import ch.e2e.test.E2ETestSuiteTemplate;
import ch.e2e.test.E2ETestSuiteTemplateFactory;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.E2ETestcaseTemplate;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.PropertiesHelper;
import ch.e2e.test.TestCreator;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.TestProperties;
import ch.e2e.test.TestSuiteProperty;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E2ETestSuite
implements Testable,
TestCreator {
    private List<Testable> testcases;
    private Map<String, Testable> testcaseMap;
    private Map<String, Element> targets;
    private TestProperties properties;
    private Map<TestType, OptionContainer> options;
    private E2ETestSuite parent;
    private E2ETestSuiteTemplate template;
    private TestLogfile logfile = null;
    private boolean library = false;
    private boolean inLibrary = false;
    private Testable runningTest;
    private TestResult testResult;
    private String name;

    public E2ETestSuite() {
        this.initialize();
    }

    public E2ETestSuite(String name, boolean library) {
        this.library = library;
        this.setName(name);
        this.initialize();
    }

    public E2ETestSuite(File[] testSuiteFiles, TestLogfile logfile) throws Exception {
        this.setName("E2ETestSuite");
        this.logfile = logfile;
        this.initialize();
        for (File testSuiteFile : testSuiteFiles) {
            this.addTestSuiteFile(testSuiteFile);
        }
    }

    public E2ETestSuite(File testSuiteFile, E2ETestSuite parent, boolean inLibrary) throws Exception {
        this.parent = parent;
        this.inLibrary = inLibrary;
        this.initialize();
        this.loadTestSuiteFile(testSuiteFile);
    }

    public E2ETestSuite(Document document, File testSuiteFile, E2ETestSuite parent, boolean inLibrary) throws Exception {
        this.parent = parent;
        this.inLibrary = inLibrary;
        this.loadTestSuiteDocument(document, testSuiteFile);
    }

    public E2ETestSuite(E2ETestSuiteTemplate template, E2ETestSuite parent, boolean inLibrary) throws Exception {
        this.template = template;
        this.parent = parent;
        this.inLibrary = inLibrary;
        this.loadFromTemplate();
    }

    @Override
    public String getId() {
        return this.getTestSuiteFile().getParentFile().getName();
    }

    public void idChanged(String oldId) {
        if (this.parent != null) {
            this.parent.changeId(this.getId(), oldId);
        }
    }

    protected void changeId(String newId, String oldId) {
        if (!newId.equals(oldId)) {
            Testable testable = this.testcaseMap.remove(oldId);
            this.testcaseMap.put(newId, testable);
        }
    }

    public E2ETestSuiteTemplate getTemplate() {
        return this.template;
    }

    public File getTestSuiteFile() {
        return this.template.getTestSuiteFile();
    }

    public void setTestSuiteFile(File testSuiteFile) {
        if (this.template == null) {
            try {
                this.template = E2ETestSuiteTemplateFactory.getInstance().getTemplate(testSuiteFile, this.inLibrary);
                this.template.setLibrary(this.library);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (this.parent != null) {
                String oldId = this.template.getTestSuiteFile().getParentFile().getName();
                String newId = testSuiteFile.getParentFile().getName();
                this.parent.changeId(newId, oldId);
            }
            E2ETestSuiteTemplateFactory.getInstance().removeTemplate(this.template.getTestSuiteFile());
            this.template.setTestSuiteFile(testSuiteFile);
        }
    }

    public boolean isLibrary() {
        return this.library;
    }

    public void setLibrary(boolean library) {
        this.library = library;
    }

    @Override
    public TestLogfile getLogfile() {
        return this.logfile;
    }

    @Override
    public void setLogfile(TestLogfile logfile) {
        this.logfile = logfile;
    }

    public TestProperties getProperties() {
        return this.properties;
    }

    public TestProperties getPropertiesWithInherited() {
        TestProperties result = new TestProperties();
        if (this.parent != null) {
            result.putAll(this.parent.getPropertiesWithInherited());
        }
        result.putAll(this.properties);
        return result;
    }

    public List<Testable> getTestcases() {
        return Collections.unmodifiableList(this.testcases);
    }

    protected void clearInternal() {
        this.testcases.clear();
        this.testcaseMap.clear();
    }

    protected void moveInternal(Testable testable, int index) {
        this.testcases.remove(testable);
        this.testcases.add(index, testable);
    }

    protected void sortByName() {
        Collections.sort(this.testcases, new Comparator<Testable>(){

            @Override
            public int compare(Testable o1, Testable o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
    }

    protected void removeInternal(Testable testable) {
        this.testcaseMap.remove(testable.getId());
        this.testcases.remove(testable);
    }

    public void replaceTestcase(E2ETestcase oldTestcase, E2ETestcase newTestcase) {
        this.testcaseMap.remove(oldTestcase.getId());
        this.testcaseMap.put(newTestcase.getId(), newTestcase);
        int index = this.testcases.indexOf(oldTestcase);
        if (index == -1) {
            this.testcases.add(newTestcase);
        } else {
            this.testcases.remove(index);
            this.testcases.add(index, newTestcase);
        }
    }

    @Override
    public void deleteLogfile() {
        for (Testable testcase : this.testcases) {
            testcase.deleteLogfile();
        }
    }

    public void addTest(Test test, int index) {
        if (test instanceof Testable) {
            Testable testable = (Testable)test;
            testable.setParent(this);
            testable.setInLibrary(this.isLibrary() || this.isInLibrary());
            if (index < this.testcases.size()) {
                this.testcases.add(index, testable);
            } else {
                this.testcases.add(testable);
            }
            this.testcaseMap.put(testable.getId(), testable);
        }
    }

    public void addTest(Test test) {
        if (test instanceof Testable) {
            Testable testable = (Testable)test;
            testable.setParent(this);
            testable.setInLibrary(this.library || this.inLibrary);
            this.testcaseMap.put(testable.getId(), testable);
            this.testcases.add(testable);
        }
    }

    public int countTestCases() {
        int count = 0;
        for (Testable test : this.testcases) {
            if (test instanceof E2ETestSuite || test instanceof E2ETestcase && !(((E2ETestcase)test).getTest() instanceof E2ETask)) {
                count += test.countTestCases();
                continue;
            }
            if (test instanceof E2ETestcase) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Testable getParent() {
        return this.parent;
    }

    public Testable getTest(String key) {
        return this.testcaseMap.get(key);
    }

    @Override
    public void setParent(E2ETestSuite parent) {
        this.parent = parent;
    }

    @Override
    public boolean isInLibrary() {
        return this.inLibrary;
    }

    @Override
    public void setInLibrary(boolean inLibrary) {
        this.inLibrary = inLibrary;
    }

    @Override
    public Testable clone() throws CloneNotSupportedException {
        E2ETestSuite testSuite = (E2ETestSuite)super.clone();
        testSuite.testcases = new ArrayList<Testable>();
        testSuite.testcaseMap = new HashMap<String, Testable>();
        for (Testable testcase : this.testcases) {
            testSuite.addTest(testcase.clone());
        }
        return testSuite;
    }

    protected void reload() throws Exception {
        this.clean();
        this.loadFromTemplate();
    }

    private void loadFromTemplate() throws Exception {
        this.template.reload();
        this.setName(this.template.getName());
        this.library = this.template.isLibrary();
        this.inLibrary = this.template.isInLibrary();
        this.initialize();
        for (String key : this.template.getProperties().keySet()) {
            String value = this.template.getProperties().get(key);
            this.properties.put(key, value);
        }
        for (TestType testType : this.template.getOptions().keySet()) {
            OptionContainer container = this.template.getOptions().get(testType);
            OptionContainer clone = container.clone();
            clone.setOwner(this);
            this.options.put(testType, clone);
        }
        this.targets = this.template.getTargets();
        for (Testable testable : this.template.getTestcases()) {
            if (testable instanceof E2ETestSuiteTemplate) {
                this.addTest(this.createTestSuite((E2ETestSuiteTemplate)testable, this.inLibrary || this.library));
                continue;
            }
            if (!(testable instanceof E2ETestcaseTemplate)) continue;
            E2ETestcaseTemplate testcaseTemplate = (E2ETestcaseTemplate)testable;
            this.addTest(this.createTestcase(testcaseTemplate.getElement(), testcaseTemplate.getParentFile()));
        }
    }

    @Override
    public void clean() {
        for (Testable testcase : this.testcases) {
            testcase.clean();
        }
        this.testcases.clear();
        this.testcaseMap.clear();
        this.targets.clear();
        this.options.clear();
        this.properties.clear();
    }

    private void addTestSuiteFile(File testcaseFile) throws Exception {
        Document testDocument = this.getTestSuiteDocument(testcaseFile);
        if (testDocument != null) {
            this.addTestcaseDocument(testDocument, testcaseFile);
        }
    }

    protected Document getTestSuiteDocument(File testcaseFile) throws Exception {
        Document result = null;
        if (testcaseFile.exists()) {
            result = DomUtilities.parse((File)testcaseFile, (boolean)false, (boolean)false);
        }
        return result;
    }

    private void addTestcaseDocument(Document testDocument, File testcaseFile) throws Exception {
        Element document = testDocument.getDocumentElement();
        this.library = document.getNodeName().equalsIgnoreCase("library");
        this.addProperties(document);
        this.addTargets(document);
        NodeList children = document.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("include")) {
                this.addIncludesFile((Element)child, testcaseFile);
                continue;
            }
            if (child.getNodeName().equals("testcase") || child.getNodeName().equals("task")) {
                this.loadTestcase((Element)child, testcaseFile.getParentFile());
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("test") || child.getNodeName().equalsIgnoreCase("resultTest") || child.getNodeName().equalsIgnoreCase("source")) {
                this.addType((Element)child, testcaseFile);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("globaltestoptions") || child.getNodeName().equalsIgnoreCase("options") || child.getNodeName().equalsIgnoreCase("globaloptions")) {
                this.addOptions((Element)child);
                continue;
            }
            if (!child.getNodeName().equals("logfile")) continue;
            this.logfile = new TestLogfile((Element)child, testcaseFile.getParentFile());
        }
    }

    private void addTargets(Element document) {
        try {
            NodeList targets = (NodeList)DomUtilities.evaluate((Node)document, (String)"/testcases/target", (QName)XPathConstants.NODESET);
            int length = targets.getLength();
            for (int i = 0; i < length; ++i) {
                if (!(targets.item(i) instanceof Element)) continue;
                Element target = (Element)targets.item(i);
                this.targets.put(target.getAttribute("name"), target);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void addProperties(Element element) {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase("property")) continue;
            TestSuiteProperty property = PropertiesHelper.createProperty((Element)child, this.properties);
            this.properties.put(property.getKey(), property.getValue());
        }
    }

    protected void addIncludesFile(Element include, File testcaseFile) throws Exception {
        String unless;
        PropertiesHelper.replaceProperties(include, (Map<String, String>)this.properties);
        String ifString = include.hasAttribute("if") ? include.getAttribute("if") : null;
        String string = unless = include.hasAttribute("unless") ? include.getAttribute("unless") : null;
        if (StringTools.checkIfUnless((String)ifString, (String)unless, (Map)this.properties)) {
            String filename = include.getAttribute("file").replace('\\', '/');
            File includeFile = E2ETestSuite.createTestsuiteFile(filename, testcaseFile.getParentFile());
            E2ETestSuiteTemplate template = E2ETestSuiteTemplateFactory.getInstance().getTemplate(includeFile, this.library || this.inLibrary);
            if (template != null) {
                this.addTest(template);
                for (String target : template.getTargets().keySet()) {
                    if (this.targets.containsKey(target)) continue;
                    this.targets.put(target, template.getTargets().get(target));
                }
            }
        }
    }

    @Override
    public E2ETestSuite createTestSuite(E2ETestSuiteTemplate template, boolean inLibrary) throws Exception {
        return new E2ETestSuite(template, this, inLibrary);
    }

    public void loadTestSuiteFile(File testcaseFile) throws Exception {
        Document testDocument = this.getTestSuiteDocument(testcaseFile);
        if (testDocument != null) {
            this.loadTestSuiteDocument(testDocument, testcaseFile);
        }
    }

    public void run(TestResult result) {
        this.testResult = result;
        if (this.logfile != null) {
            result.addListener((TestListener)this.logfile);
        }
        HashMap<String, String> oldProperties = new HashMap<String, String>();
        for (String key : this.properties.keySet()) {
            if (System.getProperties().contains(key)) {
                oldProperties.put(key, System.getProperty(key));
            }
            System.setProperty(key, this.properties.get(key));
        }
        int length = this.testcases.size();
        for (int i = 0; i < length && !result.shouldStop(); ++i) {
            this.runningTest = this.testcases.get(i);
            this.runningTest.run(result);
        }
        for (String key : this.properties.keySet()) {
            System.getProperties().remove(key);
        }
        System.getProperties().putAll((Map<?, ?>)oldProperties);
        if (this.logfile != null) {
            result.removeListener((TestListener)this.logfile);
        }
        this.testResult = null;
        this.runningTest = null;
    }

    @Override
    public void cancel() {
        if (this.runningTest != null) {
            this.testResult.stop();
            this.runningTest.cancel();
        }
    }

    public OptionContainer getInheritedOptions(TestType type, boolean includeTestSuiteOptions) {
        OptionContainer result = null;
        if (type != null) {
            E2ETestSuite parent;
            ArrayList<Object> froms = new ArrayList<Object>();
            E2ETestSuite e2ETestSuite = parent = includeTestSuiteOptions ? this : (E2ETestSuite)this.getParent();
            while (parent != null) {
                OptionContainer optionContainer = parent.getOptions().get(type);
                if (optionContainer != null) {
                    froms.add(0, optionContainer);
                }
                parent = (E2ETestSuite)parent.getParent();
            }
            try {
                result = (OptionContainer)type.newInstance();
                for (OptionContainer optionContainer : froms) {
                    Utilities.mergeOptions(optionContainer, result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static File createTestsuiteFile(String filename, File parentFile) {
        File testsuiteFile = new File(filename);
        if (!testsuiteFile.isAbsolute()) {
            testsuiteFile = new File(parentFile, filename);
        }
        testsuiteFile = new File(FileUtilities.getAbsolutePath((File)testsuiteFile));
        return testsuiteFile;
    }

    public String toString() {
        return this.getName();
    }

    protected Map<String, Element> getTargets() {
        return this.targets;
    }

    protected Map<TestType, OptionContainer> getOptions() {
        return this.options;
    }

    @Override
    public Testable createTestcase(Element testcaseElement, File parentFile) throws Exception {
        return new E2ETestcase(testcaseElement, parentFile);
    }

    protected void addTypeProperties(Properties typeProperties) {
        TypeFactory.getInstance().addTypes(typeProperties, false, false);
    }

    private Testable loadTestcase(Element testcaseElement, File parentFile) throws Exception {
        this.appendTargetCalls(testcaseElement);
        Testable testcase = this.createTestcase(testcaseElement, parentFile);
        this.addTest(testcase);
        return testcase;
    }

    private void appendTargetCalls(Element testcaseElement) {
        ArrayList<Node> elementsToRemove = new ArrayList<Node>();
        NodeList children = testcaseElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase("call")) continue;
            String target = ((Element)child).getAttribute("target");
            this.appendTargetChildren(testcaseElement, target);
            elementsToRemove.add(child);
        }
        for (Node node : elementsToRemove) {
            testcaseElement.removeChild(node);
        }
    }

    private void appendTargetChildren(Element testcaseElement, String name) {
        Element targetNode = this.findTarget(name);
        if (targetNode != null) {
            NodeList children = targetNode.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node importedNode = testcaseElement.getOwnerDocument().adoptNode(children.item(i).cloneNode(true));
                testcaseElement.appendChild(importedNode);
            }
        }
    }

    private Element findTarget(String name) {
        Element targetNode = this.targets.get(name);
        for (E2ETestSuite parent = this.parent; targetNode == null && parent != null; parent = (E2ETestSuite)parent.getParent()) {
            targetNode = parent.getTargets().get(name);
        }
        return targetNode;
    }

    private void addType(Element type, File testcaseFile) throws ClassNotFoundException {
        PropertiesHelper.replaceProperties(type, (Map<String, String>)this.properties);
        if (type.hasAttribute("resource")) {
            String resource = type.getAttribute("resource").replace('\\', '/');
            File propertiesFile = E2ETestSuite.createTestsuiteFile(resource, testcaseFile.getParentFile());
            Properties typeProperties = propertiesFile.exists() ? new Properties(propertiesFile) : new Properties(resource);
            this.addTypeProperties(typeProperties);
        } else if (type.hasAttribute("name")) {
            if (type.hasAttribute("type")) {
                TypeFactory.getInstance().addType(type.getAttribute("name"), type.getAttribute("type"), DomUtilities.getBoolean((Element)type, (String)"create", (boolean)true), false, type.getAttribute("icon"));
            } else if (type.hasAttribute("class")) {
                TypeFactory.getInstance().addType(type.getAttribute("name"), type.getAttribute("class"), true, false, type.getAttribute("icon"));
            }
        }
    }

    private void addOptions(Element testOptions) throws Exception {
        TestType type = null;
        if (testOptions.hasAttribute("type")) {
            type = TypeFactory.getInstance().getType(PropertiesHelper.replaceProperties(testOptions.getAttribute("type"), (Map<String, String>)this.properties));
        } else if (testOptions.hasAttribute("name")) {
            type = TypeFactory.getInstance().getType(PropertiesHelper.replaceProperties(testOptions.getAttribute("name"), (Map<String, String>)this.properties));
        }
        if (type != null) {
            Object optionContainer = type.newInstance();
            optionContainer.setOwner(this);
            optionContainer.mergeOptions(testOptions, this.properties);
            this.options.put(type, (OptionContainer)optionContainer);
        }
    }

    private void initialize() {
        this.properties = new TestProperties();
        this.targets = new HashMap<String, Element>();
        this.testcases = new ArrayList<Testable>();
        this.testcaseMap = new HashMap<String, Testable>();
        this.options = new HashMap<TestType, OptionContainer>();
    }

    protected void loadTestSuiteDocument(Document document, File testcaseFile) throws Exception {
        this.initialize();
        if (document.getDocumentElement().hasAttribute("name")) {
            this.setName(document.getDocumentElement().getAttribute("name"));
        } else {
            this.setName(testcaseFile.getName());
        }
        this.addTestcaseDocument(document, testcaseFile);
    }

    @Override
    public boolean canWrite() {
        return this.template.getTestSuiteFile().canWrite();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

