/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.tabfiles;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class Tabfile {
    private static String lineSeparator = "\n";
    protected File file;
    private Row columnNames;
    private ArrayList<Row> rows = new ArrayList();
    private long lastModified;

    public Tabfile(File dir, String name, String[] columnNames) {
        this(dir, name, new Row(columnNames));
    }

    protected Tabfile(File dir, String name, Row columnNames) {
        this(dir, name);
        this.columnNames = columnNames;
    }

    protected Tabfile(File dir, String name) {
        this.file = new File(dir, name + ".tab");
        this.lastModified = this.file.lastModified();
    }

    public boolean delete() {
        return this.file.delete();
    }

    public void appendRow(String[] entries) {
        this.appendRow(new Row(entries));
    }

    public void appendRow(Row row) {
        if (!this.rows.contains(row)) {
            this.rows.add(row);
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public Row getColumnNames() {
        return this.columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() throws IOException {
        Row[] rowArray = new Row[this.rows.size()];
        this.rows.toArray(rowArray);
        this.formatOutput(rowArray);
        OutputStream out = null;
        try {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(this.file);
            this.writeRow(this.columnNames, (FileOutputStream)out);
            for (Row aRowArray : rowArray) {
                this.writeRow(aRowArray, (FileOutputStream)out);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((FileOutputStream)out).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean hasChanged() {
        return this.lastModified < this.file.lastModified();
    }

    protected void setColumnNames(Row columnNames) {
        this.columnNames = columnNames;
    }

    private void formatColumn(Row[] rowArray, int index, int maxLength) {
        ((Row)this.columnNames).entries[index] = StringTools.appendSpaces((String)this.columnNames.entries[index], (int)maxLength);
        for (Row aRowArray : rowArray) {
            if (index >= aRowArray.entries.length) continue;
            if (aRowArray.entries[index] == null) {
                ((Row)aRowArray).entries[index] = "";
            }
            ((Row)aRowArray).entries[index] = index == aRowArray.entries.length - 2 ? StringTools.prependSpaces((String)aRowArray.entries[index], (int)maxLength) : StringTools.appendSpaces((String)aRowArray.entries[index], (int)maxLength);
        }
    }

    private void formatOutput(Row[] rowArray) {
        if (this.columnNames.entries.length > 2) {
            for (int i = 0; i < rowArray[0].entries.length - 1; ++i) {
                int maxLength = this.getMaxLength(rowArray, i);
                this.formatColumn(rowArray, i, maxLength);
            }
        }
    }

    private int getMaxLength(Row[] rowArray, int index) {
        int maxLength = this.columnNames.entries[index].length();
        for (Row aRowArray : rowArray) {
            if (aRowArray.entries.length <= index || aRowArray.entries[index] == null || maxLength >= aRowArray.entries[index].length()) continue;
            maxLength = aRowArray.entries[index].length();
        }
        return maxLength;
    }

    private void writeRow(Row row, FileOutputStream out) throws IOException {
        int length = row.entries.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                out.write(32);
            }
            out.write(row.entries[i].getBytes("UTF-8"));
        }
        out.write(lineSeparator.getBytes("UTF-8"));
    }

    static {
        String system = E2EBuilder.getInstance().getProperties().getString("tabfile_system", "unix");
        lineSeparator = system.equals("unix") ? "\n" : "\r\n";
    }

    public static class Row {
        private String[] entries;

        protected Row(String[] entries) {
            this.entries = entries;
        }

        public String[] getEntries() {
            return this.entries;
        }

        public boolean equals(Object other) {
            String[] otherEntries = ((Row)other).entries;
            if (this.entries.length != otherEntries.length) {
                return false;
            }
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].equals(otherEntries[i])) continue;
                return false;
            }
            return true;
        }
    }
}

