/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.ProjectSetting;
import ch.e2e.builder.base.project.gui.ActionButton;
import ch.e2e.builder.base.project.gui.GeneralProjectSettingsPanel;
import ch.e2e.builder.base.project.gui.ModulePanel;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Iterator;

public class ProjectDialog
extends E2EBuilderDialog
implements ProjectConstants,
InputFieldListener {
    protected GeneralProjectSettingsPanel generalSettingsPanel;
    protected HashMap<String, ModulePanel> modulePanels = new HashMap();
    protected E2EBuilderProject project;
    private JideTabbedPane tabbedPane;
    private Window parent;

    public ProjectDialog(Iterator<E2EBuilderModule> builderModules, String title, String internalTitle, String subtitle) {
        super(title, internalTitle, subtitle, 3);
        this.createGui(builderModules);
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public boolean editProject(E2EBuilderProject project, E2EBuilderModule module) {
        this.project = project;
        this.fillProjectInfo();
        this.generalSettingsPanel.setNameFieldEditable(false);
        this.setStartPane(module);
        return this.showDialog() == 1;
    }

    public boolean doOnOk() {
        boolean result;
        try {
            this.fillProject();
            result = true;
            this.generalSettingsPanel.doOnOk();
            for (ModulePanel modulePanel : this.modulePanels.values()) {
                modulePanel.doOnOk();
            }
        }
        catch (PropertyVetoException pvEx) {
            result = false;
        }
        return result;
    }

    public boolean doOnCancel() {
        this.generalSettingsPanel.doOnCancel();
        for (ModulePanel modulePanel : this.modulePanels.values()) {
            modulePanel.doOnCancel();
        }
        return true;
    }

    public void inputFieldChanged(InputFieldEvent e) {
        boolean okButtonEnabled = true;
        Iterator<ModulePanel> modules = this.modulePanels.values().iterator();
        while (modules.hasNext() && okButtonEnabled) {
            ModulePanel modulePanel = modules.next();
            okButtonEnabled = modulePanel.isComplete();
        }
        this.setOkButtonEnabled(okButtonEnabled);
    }

    protected void setStartPane(E2EBuilderModule module) {
        if (module == null) {
            this.tabbedPane.setSelectedIndex(0);
        } else {
            String name = module.getName();
            ModulePanel panel = this.modulePanels.get(name);
            if (panel == null) {
                this.tabbedPane.setSelectedIndex(0);
            } else {
                this.tabbedPane.setSelectedComponent((Component)panel);
            }
        }
    }

    private void fillProjectInfo() {
        this.generalSettingsPanel.fillProjectInfo(this.project);
        for (ModulePanel modulePanel : this.modulePanels.values()) {
            modulePanel.fillProjectInfo(this.project);
        }
    }

    void fillProject() throws PropertyVetoException {
        this.generalSettingsPanel.fillProject(this.project);
        for (ModulePanel modulePanel : this.modulePanels.values()) {
            modulePanel.fillProject(this.project);
        }
    }

    private void createGui(Iterator<E2EBuilderModule> builderModules) {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JideTabbedPane();
        this.generalSettingsPanel = new GeneralProjectSettingsPanel(this);
        this.tabbedPane.addTab(this.getTranslation("project.info"), (Component)this.generalSettingsPanel);
        ModulePanel genericPanel = new ModulePanel("generic", "ch.e2e.builder.base.", (ProjectSetting[])ProjectConstants.projectEntries);
        this.tabbedPane.addTab(this.getTranslation("generic"), (Component)genericPanel);
        this.generalSettingsPanel.addProjectFolderChangedListener(genericPanel);
        this.modulePanels.put("generic", genericPanel);
        genericPanel.addInputFieldListener(this);
        while (builderModules.hasNext()) {
            E2EBuilderModule next = builderModules.next();
            ProjectSetting[] projectEntries = next.getProjectSettings();
            if (projectEntries.length <= 0) continue;
            ModulePanel modulePanel = new ModulePanel(next.getName(), next.getClass().getPackage().getName() + '.', projectEntries);
            this.modulePanels.put(next.getName(), modulePanel);
            this.generalSettingsPanel.addProjectFolderChangedListener(modulePanel);
            this.tabbedPane.addTab(next.getShorttitle(), (Component)modulePanel);
            modulePanel.addInputFieldListener(this);
            for (ActionButton button : modulePanel.getActionButtons()) {
                button.getButton().addActionListener(new ActionButtonAction(button));
            }
        }
        this.add((Component)this.tabbedPane, "Center");
        this.setMinimumWidth(400);
    }

    private String getTranslation(String key) {
        return E2EBuilderTranslator.getTranslation((String)key, (String)key);
    }

    private class ActionButtonAction
    implements ActionListener {
        private ActionButton actionButton;

        public ActionButtonAction(ActionButton actionButton) {
            this.actionButton = actionButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<String, Object> actualValues = ProjectDialog.this.modulePanels.get(this.actionButton.getAction().getModuleName()).getActualValues();
            actualValues.putAll(ProjectDialog.this.modulePanels.get("generic").getActualValues());
            this.actionButton.getAction().doAction(actualValues);
        }
    }
}

