/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.InputCheckBox;
import ch.e2e.util.StringTools;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ComponentFactory {
    private static HashMap<String, HashMap<String, Object>> modules = new HashMap();

    public static JMenu createMenu(String key, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        String[] tokens = StringTools.split((String)translation, (String)";");
        JMenu item = new JMenu(tokens.length == 0 ? "" : tokens[0]);
        if (tokens.length > 1) {
            if (tokens[1].length() > 0) {
                item.setMnemonic(tokens[1].charAt(0));
            }
            if (tokens.length == 3 && tokens[2].length() > 0) {
                item.setAccelerator(KeyStroke.getKeyStroke(tokens[2]));
            }
        }
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, item);
        return item;
    }

    public static JMenuItem createMenuItem(String key, E2EBuilderModule module) {
        return ComponentFactory.createMenuItem(key, null, module);
    }

    public static JMenuItem createMenuItem(String key, Icon icon, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        String[] tokens = StringTools.split((String)translation, (String)";");
        JMenuItem item = new JMenuItem(tokens.length == 0 ? "" : tokens[0], icon);
        if (tokens.length > 1) {
            if (tokens[1].length() > 0) {
                item.setMnemonic(tokens[1].charAt(0));
            }
            if (tokens.length == 3 && tokens[2].length() > 0) {
                item.setAccelerator(KeyStroke.getKeyStroke(tokens[2]));
            }
        }
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, item);
        return item;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String key, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        String[] tokens = StringTools.split((String)translation, (String)";");
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(tokens.length == 0 ? "" : tokens[0]);
        if (tokens.length > 1) {
            if (tokens[1].length() > 0) {
                item.setMnemonic(tokens[1].charAt(0));
            }
            if (tokens.length == 3 && tokens[2].length() > 0) {
                item.setAccelerator(KeyStroke.getKeyStroke(tokens[2]));
            }
        }
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, item);
        return item;
    }

    public static JLabel createLabel(String key) {
        return ComponentFactory.createLabel(key, (String)null);
    }

    public static JLabel createLabel(String key, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        return ComponentFactory.createLabel(key, name);
    }

    public static JLabel createLabel(String key, String module) {
        String translation = ComponentFactory.getTranslation(key, module);
        JLabel label = new JLabel(translation);
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(module);
        components.put(key, label);
        return label;
    }

    public static InputCheckBox createCheckBox(String key, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        InputCheckBox checkbox = new InputCheckBox(translation);
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, checkbox);
        return checkbox;
    }

    public static JRadioButton createRadioButton(String key, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        JRadioButton radioButton = new JRadioButton(translation);
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, radioButton);
        return radioButton;
    }

    public static JButton createButton(String key, E2EBuilderModule module) {
        String moduleName = module == null ? null : module.getModuleInfo().getName();
        return ComponentFactory.createButton(key, moduleName);
    }

    public static JButton createButton(String key) {
        return ComponentFactory.createButton(key, (String)null);
    }

    public static JButton createButton(String key, String moduleName) {
        String translation = ComponentFactory.getTranslation(key, moduleName);
        JButton button = new JButton(translation);
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(moduleName);
        components.put(key, button);
        return button;
    }

    public static TitledBorder createTitledBorder(String key, E2EBuilderModule module) {
        String name = module == null ? null : module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        TitledBorder border = new TitledBorder(translation);
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, border);
        return border;
    }

    public static TitledBorder createTitledBorder(String key, Border border, E2EBuilderModule module) {
        String name = module.getModuleInfo().getName();
        String translation = ComponentFactory.getTranslation(key, name);
        TitledBorder result = new TitledBorder(border, translation);
        HashMap<String, Object> components = ComponentFactory.getModuleComponents(name);
        components.put(key, result);
        return result;
    }

    private static String getTranslation(String key, String module) {
        String translation = module == null ? E2EBuilderTranslator.getTranslation((String)key, (String)key) : E2EBuilderTranslator.getModuleTranslation((String)module, (String)key, (String)key);
        return translation;
    }

    private static HashMap<String, Object> getModuleComponents(String module) {
        String name = module == null ? "E2EBUILDER_BASE" : module;
        HashMap<String, Object> components = modules.get(name);
        if (components == null) {
            components = new HashMap();
            modules.put(name, components);
        }
        return components;
    }
}

