/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.regtest.event.TestSuiteTreeReloadEvent;
import ch.e2e.builder.regtest.gui.OptionReplaceSelectionDialog;
import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.builder.regtest.gui.swing.OptionPanel;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.Testable;
import ch.e2e.test.options.Option;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class OptionsDialog
extends E2EBuilderDialog
implements OptionInputChangedListener {
    private static OptionsDialog dialog;
    private OptionPanel testActionOptions;
    private E2EBuilderModule module;
    private HashMap<String, OptionComponent> options;
    private OptionContainer optionContainer;

    private OptionsDialog(E2EBuilderModule module) {
        super(module.getTranslation("testcase.preferences.dialog.title"), module.getTranslation("testcase.preferences.dialog.internaltitle"), module.getTranslation("testcase.preferences.dialog.subtitle"), 3);
        this.module = module;
        this.createGui(module);
    }

    public static OptionsDialog getInstance(E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new OptionsDialog(module);
        }
        return dialog;
    }

    public boolean editOptions(OptionContainer optionContainer, boolean setDefaultValue, boolean isNew) {
        this.optionContainer = optionContainer;
        this.clearOptionListeners();
        this.options = this.testActionOptions.setOptions(optionContainer.getOptions().values(), optionContainer.getAdvancedOptions().values(), this.isReadOnly(optionContainer), false);
        this.addOptionDependencies(this.options);
        boolean result = false;
        if (dialog.showDialog(true) == 1) {
            this.testActionOptions.persist(isNew);
            Testable owner = optionContainer.getOwner();
            if (owner instanceof TreeTestSuite) {
                try {
                    TreeTestSuite testSuite = (TreeTestSuite)owner;
                    testSuite.persistOptions(optionContainer);
                    this.replaceOptions(optionContainer, testSuite);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            result = true;
            EventController.fire((EventObject)new TestSuiteTreeReloadEvent(optionContainer));
        }
        return result;
    }

    private boolean isReadOnly(OptionContainer optionContainer) {
        TreeTestSuite testSuite;
        return optionContainer.getOwner() instanceof TreeTestSuite && (!(testSuite = (TreeTestSuite)optionContainer.getOwner()).canWrite() || (testSuite.isLibrary() || testSuite.isInLibrary()) && !LibrariesRoot.isInLibraryTree(testSuite));
    }

    private void replaceOptions(OptionContainer optionContainer, TreeTestSuite testSuite) {
        List<OptionContainer> optionsToReplace = OptionReplaceSelectionDialog.getInstance(this.module).selectOptionsToReplace(testSuite, optionContainer.getType());
        if (optionsToReplace != null) {
            for (OptionContainer container : optionsToReplace) {
                for (String key : container.getOptions().keySet()) {
                    if (((Option)optionContainer.getOptions().get(key)).getValue() == null) continue;
                    ((Option)container.getOptions().get(key)).setValue(null);
                }
                for (String key : container.getAdvancedOptions().keySet()) {
                    if (((Option)optionContainer.getAdvancedOptions().get(key)).getValue() == null) continue;
                    ((Option)container.getAdvancedOptions().get(key)).setValue(null);
                }
                Testable owner = container.getOwner();
                if (owner.isInLibrary()) continue;
                if (owner instanceof Testcase) {
                    ((Testcase)owner).persist(owner.getName());
                    continue;
                }
                if (!(owner instanceof TreeTestSuite)) continue;
                try {
                    ((TreeTestSuite)owner).persistOptions(container);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void clearOptionListeners() {
        if (this.options != null) {
            for (OptionComponent component : this.options.values()) {
                component.removeOptionChangedListener(this);
                Object option = component.getOption();
                OptionComponent optionComponent = this.options.get(option.getKey());
                List dependencies = option.getDependencies();
                for (String dependency : dependencies) {
                    if (!this.options.containsKey(dependency)) continue;
                    OptionComponent dependencyComponent = this.options.get(dependency);
                    dependencyComponent.removeOptionChangedListener(optionComponent);
                    optionComponent.optionChanged(new OptionInputChangedEvent(this, dependency, dependencyComponent.getValue()));
                }
            }
        }
    }

    private void addOptionDependencies(HashMap<String, OptionComponent> addedOptions) {
        for (OptionComponent component : addedOptions.values()) {
            component.addOptionChangedListener(this);
            Object option = component.getOption();
            OptionComponent optionComponent = addedOptions.get(option.getKey());
            List dependencies = option.getDependencies();
            for (String dependency : dependencies) {
                if (!this.options.containsKey(dependency)) continue;
                OptionComponent dependencyComponent = this.options.get(dependency);
                dependencyComponent.addOptionChangedListener(optionComponent);
                optionComponent.optionChanged(new OptionInputChangedEvent(this, dependency, dependencyComponent.getValue()));
            }
        }
    }

    private void createGui(E2EBuilderModule module) {
        this.setLayout(new BorderLayout());
        this.testActionOptions = new OptionPanel((Dialog)((Object)this), E2EBuilder.getInstance().getE2EBuilderLogo(), E2EBuilderTranslator.getTranslator((String)module.getName()));
        this.testActionOptions.setIgnoreRequired(true);
        this.add(this.testActionOptions, "Center");
    }

    @Override
    public void optionChanged(OptionInputChangedEvent event) {
    }
}

