/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.regtest.event.UpdateLogViewEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.test.TestLogfile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.EventObject;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class LogView
extends JPanel {
    private JEditorPane editor;
    private LogFileReader reader = new LogFileReader();
    private Thread readThread;
    private TestLogfile logfile;
    private long lastModified;

    public LogView() {
        super(new BorderLayout());
        this.createGui();
        this.addEventHandler();
    }

    public Object getPrintableObject() {
        return this.editor;
    }

    public void setLogfile(TestLogfile logfile) {
        if (!(logfile == null || this.logfile != null && this.logfile.equals(logfile))) {
            this.logfile = logfile;
            this.lastModified = -1L;
            this.editor.setText("");
            if (logfile.exists()) {
                this.readLogFile();
            }
        } else if (logfile == null || !logfile.exists()) {
            this.logfile = logfile;
            this.lastModified = -1L;
            this.editor.setText("");
        } else if (logfile.lastModified() > this.lastModified) {
            this.lastModified = logfile.lastModified();
            if (logfile.exists()) {
                this.readLogFile();
            }
        }
    }

    private void createGui() {
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setBackground(Color.WHITE);
        this.add(new JScrollPane(this.editor, 20, 30));
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                LogView.this.setLogfile(((UpdateLogViewEvent)event).getLogfile());
            }
        }, UpdateLogViewEvent.class);
    }

    private void readLogFile() {
        if (this.reader.isOpen()) {
            this.reader.close();
        }
        if (this.readThread == null || !this.readThread.isAlive()) {
            this.readThread = new Thread(this.reader);
            this.readThread.start();
        }
    }

    private class LogFileReader
    implements Runnable {
        private FileChannel channel;
        private InputStream inputStream;

        private LogFileReader() {
        }

        @Override
        public void run() {
            final File f = LogView.this.logfile.getLogfile();
            LogView.this.editor.setText("Reading '" + f.getName() + "' ...");
            LogView.this.editor.setOpaque(false);
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    try {
                        LogFileReader.this.channel = new FileInputStream(f).getChannel();
                        LogFileReader.this.inputStream = Channels.newInputStream(LogFileReader.this.channel);
                        byte[] buffer = new byte[(int)f.length()];
                        BufferedInputStream f2 = new BufferedInputStream(LogFileReader.this.inputStream);
                        f2.read(buffer);
                        LogView.this.editor.setText(new String(buffer));
                    }
                    catch (IOException e) {
                        LogView.this.editor.setText("Reading of '" + f.getName() + "' was interrupted");
                    }
                    finally {
                        LogView.this.editor.setOpaque(true);
                        if (LogFileReader.this.inputStream != null) {
                            try {
                                LogFileReader.this.inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(worker);
        }

        public boolean isOpen() {
            return this.channel != null && this.channel.isOpen();
        }

        public void close() {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

