/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.event.TestcaseEvent;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;

public class DeleteTestcaseExecuter
implements EventExecuter {
    private E2EBuilderModule module;

    public DeleteTestcaseExecuter(E2EBuilderModule module) {
        this.module = module;
    }

    public void execute(EventObject event) {
        this.deleteTestcase((Testcase)((TestcaseEvent)event).getTestcaseObject());
    }

    public void deleteTestcase(Testcase testcase) {
        String name = testcase.getName();
        String question = this.module.getTranslation("testcase.delete.question.message");
        question = StringTools.replaceProperty((String)question, (String)"testcase", (String)name);
        String title = this.module.getTranslation("testcase.delete.question.title");
        title = StringTools.replaceProperty((String)title, (String)"testcase", (String)name);
        String subtitle = this.module.getTranslation("testcase.delete.question.subtitle");
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)(subtitle = StringTools.replaceProperty((String)subtitle, (String)"testcase", (String)name)), (String)question)) {
            TestcaseContainer container = testcase.getParent();
            try {
                container.delete((TestcaseObject)testcase);
            }
            catch (FilesNotDeletedException e) {
                for (File file : e.getFiles()) {
                    String msg = this.module.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                    this.module.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
                }
            }
            EventController.fire((EventObject)new RefreshSynchronousTreeEvent(this, (TestcaseObject)container));
        }
    }
}

