/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml;

import java.lang.reflect.Constructor;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;

public class UmlCellViewFactory
extends DefaultCellViewFactory {
    protected EdgeView createEdgeView(Object cell) {
        EdgeView view = (EdgeView)this.createView(cell);
        return view == null ? super.createEdgeView(cell) : view;
    }

    protected PortView createPortView(Object cell) {
        PortView view = (PortView)this.createView(cell);
        return view == null ? super.createPortView(cell) : view;
    }

    protected VertexView createVertexView(Object cell) {
        VertexView view = (VertexView)this.createView(cell);
        return view == null ? super.createVertexView(cell) : view;
    }

    protected Object createView(Object cell) {
        Object view = null;
        try {
            Constructor<?> constructor = this.getViewClass(cell).getConstructor(Object.class);
            view = constructor.newInstance(cell);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return view;
    }

    private Class<?> getViewClass(Object cell) throws ClassNotFoundException {
        return Class.forName(this.getViewClassName(cell));
    }

    private String getViewClassName(Object cell) {
        String name = cell.getClass().getName();
        return (cell instanceof Port ? name : name.substring(0, name.length() - 4)) + "View";
    }
}

