/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.DiagramPanel;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.gui.uml.UmlGraphFileCorruptException;
import ch.e2e.builder.trace.gui.uml.sequence.SequenceGraphBuilder;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import java.io.File;
import java.io.FileNotFoundException;

public class SequenceDiagramPanel
extends DiagramPanel {
    public SequenceDiagramPanel(E2ETraceModule module) {
        super(module, "sequence.diagram");
    }

    @Override
    protected UmlGraph createGraph() {
        Testcase testcase = this.getTestcase();
        UmlGraph graph = null;
        if (testcase != null) {
            UmlTree umlTree = testcase.getUmlTree();
            File targetFolder = testcase.getGraphFolder();
            File target = new File(targetFolder, this.getDiagramName());
            SequenceGraphBuilder sequenceGraphBuilder = new SequenceGraphBuilder(testcase, umlTree, this.getModule());
            graph = sequenceGraphBuilder.getGraph();
            try {
                if (target.exists()) {
                    try {
                        graph.readLayout(target);
                    }
                    catch (UmlGraphFileCorruptException e) {
                        graph.saveLayout(target);
                    }
                } else {
                    targetFolder.mkdirs();
                    graph.saveLayout(target);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return graph;
    }
}

