/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractXmlCodeInspector {
    private final EventListenerList listeners = new EventListenerList();
    private final XMLReader xmlReader;
    private boolean inpectionSuccessful = true;

    public AbstractXmlCodeInspector() {
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.xmlReader.setErrorHandler(this.createErrorHandler());
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract ErrorHandler createErrorHandler();

    public void addCodeInspectionListener(CodeInspectionListener listener) {
        this.listeners.add(CodeInspectionListener.class, listener);
    }

    public void removeCodeInspectionListener(CodeInspectionListener listener) {
        this.listeners.remove(CodeInspectionListener.class, listener);
    }

    protected void parse(InputSource source) throws IOException, SAXException {
        this.xmlReader.parse(source);
    }

    private void fireInspectionStatusChanged() {
        CodeInspectionEvent event = null;
        for (CodeInspectionListener listener : (CodeInspectionListener[])this.listeners.getListeners(CodeInspectionListener.class)) {
            if (event == null) {
                event = new CodeInspectionEvent(this, this.inpectionSuccessful);
            }
            listener.inspectionStatusChanged(event);
        }
    }

    public static class CodeInspectionEvent
    extends EventObject {
        private final boolean inspectionSuccessful;

        public CodeInspectionEvent(AbstractXmlCodeInspector source, boolean inspectionSuccessful) {
            super(source);
            this.inspectionSuccessful = inspectionSuccessful;
        }

        public boolean isInspectionSuccessful() {
            return this.inspectionSuccessful;
        }
    }

    public static interface CodeInspectionListener
    extends EventListener {
        public void inspectionStatusChanged(CodeInspectionEvent var1);
    }
}

