/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderFrame;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.TextEditor;
import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeEditor;
import ch.e2e.gui.event.ValueChangedEvent;
import ch.e2e.gui.event.ValueChangedListener;
import ch.e2e.swing.ListStatusBarItem;
import ch.e2e.util.StringTools;
import com.jidesoft.action.CommandBar;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.JideToggleButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.EnumMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.fife.ui.hex.swing.HexEditor;

public class TextViewer
extends TextEditor {
    private Charset charset = Charset.defaultCharset();
    private EnumMap<Mode, JideToggleButton> buttons;
    private EnumMap<Mode, JComponent> viewers;
    private JPanel container;
    private BitSet set = new BitSet(Mode.values().length);
    private JLabel truncatedLabel;
    private JLabel nonDisplayableLabel;

    public TextViewer(E2EBuilderModule module) {
        super(module);
    }

    @Override
    public void setText(String text, boolean truncated) {
        super.setText(null, truncated);
        this.resetViewers();
        this.set.clear();
        this.truncatedLabel.setVisible(truncated);
        this.nonDisplayableLabel.setVisible(false);
        this.setView(Mode.TEXT);
        this.setWaitCursor();
        new Worker(text).execute();
    }

    private void resetViewers() {
        try {
            ((HexEditor)this.viewers.get((Object)Mode.HEX)).open((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ((HexEditor)this.viewers.get((Object)Mode.BASE64HEX)).open((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((JTextArea)this.viewers.get((Object)Mode.BASE64)).setText(null);
        ((AbstractXmlCodeEditor)((Object)this.viewers.get((Object)Mode.XML))).setText(null);
    }

    @Override
    protected void createEditorPane(E2EBuilderModule module) {
        this.createToolbar(module);
        this.createViewers();
        this.createStatusBar(module);
    }

    private void createToolbar(E2EBuilderModule module) {
        CommandBar commandBar = new CommandBar();
        ButtonGroup group = new ButtonGroup();
        this.buttons = new EnumMap(Mode.class);
        this.createButton(commandBar, group, Mode.TEXT, TEXT_VIEWER_TEXT_BUTTON_ICON, module.getTranslation("text.viewer.text.button.tooltip")).setSelected(true);
        this.createButton(commandBar, group, Mode.HEX, TEXT_VIEWER_HEX_BUTTON_ICON, module.getTranslation("text.viewer.hex.button.tooltip"));
        this.createButton(commandBar, group, Mode.BASE64, TEXT_VIEWER_BASE64_BUTTON_ICON, module.getTranslation("text.viewer.base64.button.tooltip"));
        this.createButton(commandBar, group, Mode.BASE64HEX, TEXT_VIEWER_B64HEX_BUTTON_ICON, module.getTranslation("text.viewer.b64hex.button.tooltip"));
        this.createButton(commandBar, group, Mode.XML, "XML", module.getTranslation("text.viewer.xml.button.tooltip"));
        commandBar.addSeparator(new Dimension(10, commandBar.getHeight()));
        this.truncatedLabel = ComponentFactory.createLabel((String)"text.viewer.toolbar.truncated.label", (E2EBuilderModule)module);
        this.truncatedLabel.setFont(this.truncatedLabel.getFont().deriveFont(1));
        this.truncatedLabel.setForeground(Color.RED);
        this.truncatedLabel.setVisible(false);
        commandBar.add((Component)this.truncatedLabel);
        this.nonDisplayableLabel = ComponentFactory.createLabel((String)"text.viewer.toolbar.not.displayable.label", (E2EBuilderModule)module);
        this.nonDisplayableLabel.setForeground(Color.RED);
        this.nonDisplayableLabel.setVisible(false);
        commandBar.add((Component)this.nonDisplayableLabel);
        this.add((Component)commandBar, "North");
    }

    private void createStatusBar(E2EBuilderModule module) {
        StatusBar statusBar = new StatusBar();
        statusBar.add((Component)new LabelStatusBarItem(), (Object)"vary");
        ListStatusBarItem charsetItem = new ListStatusBarItem();
        charsetItem.setToolTipText(module.getTranslation("text.viewer.tooltip.file.encoding", "Select File Encoding"));
        charsetItem.setValues((Object)Charset.defaultCharset(), Charset.availableCharsets().values());
        charsetItem.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent event) {
                TextViewer.this.charset = (Charset)event.getValue();
                if (TextViewer.this.set.get(Mode.HEX.ordinal())) {
                    TextViewer.this.updateHexViewer();
                }
                if (TextViewer.this.set.get(Mode.BASE64.ordinal())) {
                    TextViewer.this.updateBas64Viewer();
                }
            }
        });
        statusBar.add((Component)charsetItem, (Object)"flexible");
        this.add((Component)statusBar, "South");
    }

    private void createViewers() {
        this.container = new JPanel(new CardLayout());
        this.viewers = new EnumMap(Mode.class);
        this.createTextViewer();
        this.createBase64Viewer();
        this.createHexViewer();
        this.createB64HexViewer();
        this.createXmlViewer();
        this.add((Component)this.container, "Center");
    }

    private void createTextViewer() {
        this.textArea.setEditable(false);
        this.viewers.put(Mode.TEXT, this.textArea);
        this.container.add((Component)new JScrollPane(this.textArea), Mode.TEXT.toString());
    }

    private void createBase64Viewer() {
        JTextArea base64Viewer = new JTextArea();
        base64Viewer.setEditable(false);
        this.viewers.put(Mode.BASE64, base64Viewer);
        this.container.add((Component)new JScrollPane(base64Viewer), Mode.BASE64.toString());
    }

    private void createHexViewer() {
        HexEditor hexEditor = new HexEditor(false);
        hexEditor.setShowColumnHeader(false);
        hexEditor.setShowRowHeader(false);
        this.viewers.put(Mode.HEX, (JComponent)hexEditor);
        this.container.add((Component)hexEditor, Mode.HEX.toString());
    }

    private void createB64HexViewer() {
        HexEditor b64HexEditor = new HexEditor(false);
        b64HexEditor.setShowColumnHeader(false);
        b64HexEditor.setShowRowHeader(false);
        this.viewers.put(Mode.BASE64HEX, (JComponent)b64HexEditor);
        this.container.add((Component)b64HexEditor, Mode.BASE64HEX.toString());
    }

    private void createXmlViewer() {
        AbstractXmlCodeEditor xmlEditor = AbstractXmlCodeEditor.createEditor(true);
        xmlEditor.setEditable(false);
        xmlEditor.setVirtualSpaceAllowed(false);
        xmlEditor.setFontSize(this.textArea.getFont().getSize());
        this.viewers.put(Mode.XML, (JComponent)((Object)xmlEditor));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)xmlEditor), "Center");
        panel.add((Component)new MarkerArea((CodeEditor)xmlEditor), "After");
        this.container.add((Component)panel, Mode.XML.toString());
    }

    private JideToggleButton createButton(CommandBar commandBar, ButtonGroup group, final Mode mode, Icon icon, String tooltip) {
        JideToggleButton button = new JideToggleButton(icon);
        button.setFocusable(false);
        if (tooltip != null && !tooltip.isEmpty()) {
            button.setToolTipText(tooltip);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextViewer.this.setView(mode);
            }
        });
        group.add((AbstractButton)button);
        commandBar.add((Component)button);
        this.buttons.put(mode, button);
        return button;
    }

    private JideToggleButton createButton(CommandBar commandBar, ButtonGroup group, final Mode mode, String title, String tooltip) {
        JideToggleButton button = new JideToggleButton(title);
        button.setFocusable(false);
        if (tooltip != null && !tooltip.isEmpty()) {
            button.setToolTipText(tooltip);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextViewer.this.setView(mode);
            }
        });
        group.add((AbstractButton)button);
        commandBar.add((Component)button);
        this.buttons.put(mode, button);
        return button;
    }

    private void setView(Mode mode) {
        this.buttons.get((Object)mode).setSelected(true);
        this.setViewer(mode);
        ((CardLayout)this.container.getLayout()).show(this.container, mode.toString());
    }

    private void setViewer(Mode mode) {
        switch (mode) {
            case HEX: {
                if (this.set.get(Mode.HEX.ordinal())) break;
                this.set.set(Mode.HEX.ordinal());
                this.updateHexViewer();
                break;
            }
            case BASE64: {
                if (this.set.get(Mode.BASE64.ordinal())) break;
                this.set.set(Mode.BASE64.ordinal());
                this.updateBas64Viewer();
                break;
            }
            case BASE64HEX: {
                if (this.set.get(Mode.BASE64HEX.ordinal())) break;
                this.set.set(Mode.BASE64HEX.ordinal());
                String text = this.getText();
                byte[] base64 = text == null ? new byte[]{} : Base64.decodeBase64((byte[])text.getBytes(Charset.forName("ascii")));
                try {
                    ((HexEditor)this.viewers.get((Object)Mode.BASE64HEX)).open((InputStream)new ByteArrayInputStream(base64));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case XML: {
                if (this.set.get(Mode.XML.ordinal())) break;
                this.set.set(Mode.XML.ordinal());
                this.setWaitCursor();
                new XmlWorker(this).execute();
            }
        }
    }

    private void updateHexViewer() {
        try {
            String text = this.getText();
            ((HexEditor)this.viewers.get((Object)Mode.HEX)).open((InputStream)new ByteArrayInputStream(text == null ? new byte[]{} : text.getBytes(this.charset)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateBas64Viewer() {
        String text = this.getText();
        text = text == null ? null : new String(Base64.decodeBase64((byte[])text.getBytes(Charset.forName("ascii"))), this.charset);
        ((JTextArea)this.viewers.get((Object)Mode.BASE64)).setText(text);
    }

    private void setDefaultCursor() {
        this.getParent().setCursor(Cursor.getPredefinedCursor(0));
        Frame applicationFrame = E2EBuilder.getInstance().getApplicationFrame();
        if (applicationFrame instanceof E2EBuilderFrame) {
            ((E2EBuilderFrame)applicationFrame).setDefaultCursor();
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setWaitCursor() {
        this.getParent().setCursor(Cursor.getPredefinedCursor(3));
        Frame applicationFrame = E2EBuilder.getInstance().getApplicationFrame();
        if (applicationFrame instanceof E2EBuilderFrame) {
            ((E2EBuilderFrame)applicationFrame).setWaitCursor();
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static enum Mode {
        TEXT,
        HEX,
        BASE64,
        BASE64HEX,
        XML;

    }

    private static class XmlWorker
    extends SwingWorker<String, Void> {
        private static final Transformer TRANSFORMER;
        private final TextViewer viewer;

        private XmlWorker(TextViewer viewer) {
            this.viewer = viewer;
        }

        @Override
        protected String doInBackground() throws Exception {
            int index;
            String text = this.viewer.getText();
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            TRANSFORMER.transform(new StreamSource(new StringReader(text)), xmlOutput);
            if (text.startsWith("<?xml") && (index = text.indexOf("?>", 4)) != -1) {
                return text.substring(0, index + 2) + '\n' + xmlOutput.getWriter().toString();
            }
            return xmlOutput.getWriter().toString();
        }

        @Override
        protected void done() {
            try {
                ((AbstractXmlCodeEditor)((Object)this.viewer.viewers.get((Object)Mode.XML))).setText((String)this.get());
            }
            catch (Exception e) {
                ((AbstractXmlCodeEditor)((Object)this.viewer.viewers.get((Object)Mode.XML))).setText(this.viewer.getText());
            }
            this.viewer.setDefaultCursor();
        }

        static {
            try {
                TRANSFORMER = TransformerFactory.newInstance().newTransformer();
                TRANSFORMER.setOutputProperty("indent", "yes");
                TRANSFORMER.setOutputProperty("omit-xml-declaration", "yes");
            }
            catch (TransformerConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class Worker
    extends SwingWorker<Boolean, Void> {
        final String text;

        private Worker(String text) {
            this.text = text;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            return StringTools.isDisplayable((String)this.text);
        }

        @Override
        protected void done() {
            Boolean displayable = true;
            try {
                displayable = (Boolean)this.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            TextViewer.this.nonDisplayableLabel.setVisible(displayable == false);
            TextViewer.super.setText(this.text, TextViewer.this.truncatedLabel.isVisible());
            TextViewer.this.set.set(Mode.TEXT.ordinal());
            TextViewer.this.setView(displayable != false ? Mode.TEXT : Mode.HEX);
            TextViewer.this.setDefaultCursor();
        }
    }
}

