/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tree.menu;

import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.gui.E2EBuilderInputDialog;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.builder.trace.tree.RenameWsdlEvent;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import java.util.EventObject;
import javax.swing.tree.TreePath;

public class RenameWsdlExecuter
implements EventExecuter {
    private TraceViewer traceViewer;

    public RenameWsdlExecuter(TraceViewer traceViewer) {
        this.traceViewer = traceViewer;
    }

    public void execute(EventObject event) {
        String oldName;
        String newName;
        AbstractWSDLFolder wsdlFolder;
        TreePath path;
        Object node;
        if (event instanceof RenameWsdlEvent && (node = (path = ((RenameWsdlEvent)event).getPath()).getLastPathComponent()) instanceof AbstractWSDLFolder && this.rename(wsdlFolder = (AbstractWSDLFolder)node, newName = this.getWSDLName(oldName = wsdlFolder.getName()))) {
            EventController.fire((EventObject)new RefreshSynchronousTreeEvent((Object)this, (TestcaseObject)wsdlFolder));
            TestcaseObject testcaseObject = this.traceViewer.getAsynchronousRoot().get(oldName);
            if (testcaseObject instanceof AsynchronousFolder && ((AsynchronousFolder)testcaseObject).rename(newName)) {
                EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, testcaseObject));
            }
        }
    }

    private String getWSDLName(String defaultName) {
        String message = this.traceViewer.getTranslation("wsdl.rename.name.message");
        String title = this.traceViewer.getTranslation("wsdl.rename.name.title");
        String subtitle = this.traceViewer.getTranslation("wsdl.rename.name.internaltitle");
        String internaltitle = this.traceViewer.getTranslation("wsdl.rename.name.subtitle");
        return E2EBuilderInputDialog.getInput((String)message, (String)defaultName, (String)title, (String)internaltitle, (String)subtitle, (String)this.traceViewer.getTranslation("wsdl.input.pattern"));
    }

    private boolean rename(AbstractWSDLFolder wsdlFolder, String newName) {
        boolean renamed = false;
        if (newName != null && !newName.isEmpty() && !wsdlFolder.getName().equals(newName)) {
            if (wsdlFolder.getParent().exists(newName)) {
                this.showWSDLExistsError();
            } else {
                renamed = wsdlFolder.rename(newName);
                if (!renamed) {
                    this.showRenameError();
                }
            }
        }
        return renamed;
    }

    private void showRenameError() {
        String message = this.traceViewer.getTranslation("wsdl.rename.error.message");
        String subtitle = this.traceViewer.getTranslation("wsdl.rename.error.internaltitle");
        String internaltitle = this.traceViewer.getTranslation("wsdl.rename.error.subtitle");
        E2EBuilderInfoDialog.error((String)internaltitle, (String)subtitle, (String)message);
    }

    private void showWSDLExistsError() {
        String message = this.traceViewer.getTranslation("wsdl.rename.error.exists.message");
        String subtitle = this.traceViewer.getTranslation("wsdl.rename.error.exists.internaltitle");
        String internaltitle = this.traceViewer.getTranslation("wsdl.rename.error.exists.subtitle");
        E2EBuilderInfoDialog.error((String)internaltitle, (String)subtitle, (String)message);
    }
}

