/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.MainPanelView;
import ch.e2e.builder.trace.gui.testcase.TabbedView;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.swing.StatesView;
import ch.e2e.builder.traceviewer.swing.WSDLTreePanel;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.builder.traceviewer.testcase.PersistentStateTestcaseFolder;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AsynchronousFolderView
extends MainPanelView
implements ChangeListener {
    protected JideTabbedPane tabs;
    protected StatesView selectedView;
    private AsynchronousFolder root;
    private WSDLTreePanel overview;
    private TraceViewer traceViewer;

    public AsynchronousFolderView(TraceViewer traceViewer) {
        this.traceViewer = traceViewer;
        this.createGui();
        this.tabs.addChangeListener((ChangeListener)this);
    }

    public void setEnabled(boolean enabled) {
        this.tabs.setEnabled(enabled);
    }

    public void requestFocus() {
        Component component;
        if (this.tabs != null && (component = this.tabs.getSelectedComponent()) != null) {
            component.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    public void refresh() {
        ((StatesView)this.tabs.getSelectedComponent()).refresh();
    }

    public Object getPrintableObject() {
        Component component;
        Object result = null;
        if (this.tabs != null && (component = this.tabs.getSelectedComponent()) != null && component instanceof TabbedView) {
            result = ((TabbedView)component).getPrintableObject();
        }
        return result;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        if (!(root == null || this.root != null && this.root.equals(root))) {
            this.root = (AsynchronousFolder)root;
            this.tabs.removeAll();
            this.removeAll();
            if (this.root.hasPersitentStates()) {
                this.add((Component)this.tabs, "Center");
                for (PersistentStateTestcaseFolder folder : this.root.getPersitentStates()) {
                    this.tabs.addTab(folder.getName(), (Component)new StatesView(folder, (E2EBuilderModule)this.traceViewer));
                }
                this.setSelectedView((StatesView)this.tabs.getComponentAt(0));
            } else {
                this.add((Component)((Object)this.overview), "Center");
                this.overview.setRoot(root);
            }
        }
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.tabs = new JideTabbedPane();
        this.overview = new WSDLTreePanel();
    }

    private void setSelectedView(StatesView selectedView) {
        this.selectedView = selectedView;
        this.tabs.setSelectedComponent((Component)selectedView);
    }
}

