/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.traceviewer.execute.ImportTestcaseException;
import ch.e2e.builder.traceviewer.importer.TestcasesImporter;
import ch.e2e.builder.traceviewer.logimport.Log;
import ch.e2e.builder.traceviewer.logimport.LogRequest;
import ch.e2e.builder.traceviewer.logimport.LogResponse;
import ch.e2e.dom.DomUtilities;
import ch.e2e.log.LogParser;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportTestcasesTransaction
extends E2EBuilderTransaction {
    private final E2EBuilderModule module;

    public ImportTestcasesTransaction(E2EBuilderModule module) {
        this.module = module;
    }

    public Object doTransaction(Object transactionData) throws Throwable {
        boolean imported = false;
        TestcasesImporter.Data data = (TestcasesImporter.Data)transactionData;
        try (LogInputStream in = new LogInputStream(new FileInputStream(data.getLogFile()));){
            if (data.getTestcaseContainer() instanceof AbstractWSDLFolder) {
                imported = this.importTestcases((AbstractWSDLFolder)data.getTestcaseContainer(), new Log(new LogParser((InputStream)in)));
            } else if (data.getTestcaseContainer() instanceof AbstractTestcaseFolder) {
                imported = this.importTestcases((AbstractTestcaseFolder)data.getTestcaseContainer(), new Log(new LogParser((InputStream)in)));
            }
        }
        return imported;
    }

    private boolean importTestcases(AbstractWSDLFolder wsdlFolder, Log log) throws Throwable {
        boolean imported = false;
        for (LogRequest logRequest : log.getRequests()) {
            AbstractTestcaseFolder testcaseFolder = wsdlFolder.getTestcaseFolder(logRequest.getQualifiedOperation());
            if (testcaseFolder == null) continue;
            imported |= this.importTestcases(testcaseFolder, logRequest, log.getResponse(logRequest));
        }
        return imported;
    }

    private boolean importTestcases(AbstractTestcaseFolder testcaseFolder, Log log) throws Throwable {
        boolean imported = false;
        for (LogRequest logRequest : log.getRequests()) {
            if (!testcaseFolder.getQualifiedOperationName().equals(logRequest.getQualifiedOperation())) continue;
            imported |= this.importTestcases(testcaseFolder, logRequest, log.getResponse(logRequest));
        }
        return imported;
    }

    /*
     * Unable to fully structure code
     */
    private boolean importTestcases(AbstractTestcaseFolder testcaseFolder, LogRequest logRequest, LogResponse logResponse) throws Throwable {
        testcase = testcaseFolder.createTestcase(testcaseFolder.findDefaultTestcaseName());
        testcase.setCustomLocation(logRequest.getLocation());
        testcase.clearResult();
        testcase.saveProperties();
        testcase.getTraceFolder().mkdirs();
        request = null;
        if (testcase.isRPCEncoding()) {
            try {
                request = testcase.getRequest();
                bodyElement = logRequest.getBodyElement();
                parameters = logRequest.getParameterList();
                if (parameters == null) ** GOTO lbl32
                iterator = DomUtilities.elementIterator((NodeList)parameters);
                while (iterator.hasNext()) {
                    element = (Element)iterator.next();
                    parameter = request.getParameter(element.getNodeName());
                    if (parameter == null) {
                        throw new ImportTestcaseException("testcase.import.parameter.not.found", new String[]{testcase.getName(), element.getNodeName()});
                    }
                    ParameterFactory.setupParameter((Element)bodyElement, (Element)element, (Parameter)parameter);
                }
            }
            catch (Throwable e) {
                testcase.delete();
                throw e;
            }
        } else {
            try {
                request = testcase.getRequest();
            }
            catch (ParserConfigurationException | SAXException var6_8) {
                // empty catch block
            }
            testcase.setRequestData(DomUtilities.asString((Node)logRequest.getRequest()));
        }
lbl32:
        // 3 sources

        this.setupHttpHeaders(testcase, logRequest);
        this.setupTraceSettings(testcase, logRequest);
        testcase.saveRequest();
        this.writeRequestLog(logRequest, testcase);
        if (logResponse != null) {
            this.writeResponseLog(logResponse, testcase);
            testcase.setResponse(new SOAPResponse(logResponse.getResponse(), request == null ? null : request.getNamespacesManager()));
        }
        return true;
    }

    private void setupHttpHeaders(AbstractSynchronousTestcase testcase, LogRequest logRequest) {
        String remoteUser = (String)logRequest.getHttpHeaders().get("Remote-User");
        if (remoteUser != null) {
            Properties properties = testcase.getHttpHeaders();
            properties.setProperty("Remote-User", remoteUser);
            try {
                properties.write();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupTraceSettings(AbstractSynchronousTestcase testcase, LogRequest logRequest) {
        if (logRequest.getTraceLevel() != null) {
            testcase.getTraceSettings().setTraceLevel(logRequest.getTraceLevel());
        }
        if (logRequest.getTraceMaxSize() != null) {
            testcase.getTraceSettings().setMaxSize(logRequest.getTraceMaxSize().intValue());
        }
        testcase.saveProperties();
    }

    private void writeRequestLog(LogRequest logRequest, AbstractSynchronousTestcase testcase) throws IOException, TransformerException {
        PrintWriter out = testcase.getRequestLog().getWriter();
        out.println("POST " + logRequest.getPath() + " " + logRequest.getHttpVersion());
        for (Map.Entry entry : logRequest.getHttpHeaders().entrySet()) {
            String value = (String)entry.getValue();
            out.println((String)entry.getKey() + (value == null ? ":" : ": " + value));
        }
        out.println();
        DomUtilities.serialize((Writer)out, (Node)logRequest.getRequest(), (boolean)true, (boolean)false);
        out.flush();
        out.close();
    }

    private void writeResponseLog(LogResponse logResponse, AbstractSynchronousTestcase testcase) throws IOException, TransformerException {
        PrintWriter out = testcase.getResponseLog().getWriter();
        for (String header : logResponse.getHttpHeaders()) {
            out.println(header);
        }
        out.println();
        String indentStr = System.getProperty("ch.e2e.builder.traceviewer.response.log.indent");
        DomUtilities.serialize((Writer)out, (Node)logResponse.getResponse(), (indentStr == null || Boolean.parseBoolean(indentStr) ? 1 : 0) != 0, (boolean)false);
        out.flush();
        out.close();
    }

    public void prepareTransaction() {
    }

    public void setTransactionResult(Object transactionResult) {
        if (Boolean.parseBoolean(transactionResult.toString())) {
            this.module.refresh();
        }
    }

    public String getDescription() {
        return "Testcases Import";
    }

    public boolean doErrorHandling(Throwable error) {
        if (error instanceof ImportTestcaseException) {
            String message = this.module.getTranslation(error.getMessage());
            Map<String, String> params = ((ImportTestcaseException)error).getParams();
            this.module.showError(StringTools.replaceProperties((String)message, params));
        } else {
            this.module.showError(error.getMessage() == null ? error.getClass().getName() : error.getMessage());
        }
        return false;
    }

    private static class LogInputStream
    extends FilterInputStream {
        private boolean endReached = false;

        protected LogInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            if (this.endReached) {
                return -1;
            }
            int read = super.read();
            this.endReached = read == -1;
            return this.endReached ? 10 : read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.endReached) {
                return -1;
            }
            int n = super.read(b, off, len);
            boolean bl = this.endReached = n == -1;
            if (this.endReached) {
                b[0] = 10;
                return 1;
            }
            return n;
        }
    }
}

