/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.uml;

import ch.e2e.builder.analyzer.gui.uml.CustomBox;
import ch.e2e.builder.analyzer.gui.uml.Message;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;

public abstract class ActivationBox {
    public static final double WIDTH = 10.0;
    private ActivationBox parent;
    private ArrayList<ActivationBox> children = new ArrayList();
    private Message callMessage;
    private Message returnMessage;
    private int duration = -1;

    public abstract String getLifelineKey();

    public abstract String getLifelineName();

    public ActivationBox(TransactionLogEntry entry) {
        this.setCallMessage(entry);
    }

    public String getCellKey() {
        return "box_" + this.getStartLine();
    }

    public Message getCallMessage() {
        return this.callMessage;
    }

    public void setCallMessage(TransactionLogEntry entry) {
        this.callMessage = new Message(entry);
    }

    public Message getReturnMessage() {
        return this.returnMessage;
    }

    public void setReturnMessage(TransactionLogEntry entry) {
        this.returnMessage = new Message(entry);
        this.duration = this.returnMessage.getElapsedTime() - this.callMessage.getElapsedTime();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getStartLine() {
        return this.getCallMessage().getLine();
    }

    public int getEndLine() {
        return this.getReturnMessage().getLine();
    }

    public int getStartIndex() {
        return this.getCallMessage().getIndex();
    }

    public int getEndIndex() {
        return this.getReturnMessage().getIndex();
    }

    public ArrayList<ActivationBox> getChildren() {
        return this.children;
    }

    public void add(ActivationBox child) {
        this.children.add(child);
        child.setParent(this);
    }

    public ActivationBox getParent() {
        return this.parent;
    }

    public void setParent(ActivationBox parent) {
        this.parent = parent;
    }

    public mxCell findCell(mxGraph graph, String cellKey) {
        return (mxCell)((mxGraphModel)graph.getModel()).getCell(cellKey);
    }

    public mxCell createCell(mxGraph graph, mxCell parentCell) {
        mxCell cell = (mxCell)graph.insertVertex((Object)parentCell, this.getCellKey(), (Object)this, 0.0, 0.0, 10.0, this.getHeight(), "activationBox");
        cell.getGeometry().setOffset(new mxPoint(-10.0, -5.0));
        this.createCustomBoxes(graph, parentCell);
        return cell;
    }

    public void createCustomBoxes(mxGraph graph, mxCell parentCell) {
        for (ActivationBox child : this.getChildren()) {
            if (!(child instanceof CustomBox)) continue;
            child.createCell(graph, parentCell);
        }
    }

    public double getHeight() {
        return 30.0 * (double)(this.getEndIndex() - this.getStartIndex());
    }

    public boolean createEdges(mxGraph graph) {
        mxCell sourceCell;
        boolean created = false;
        ActivationBox caller = this.getCaller();
        if (caller != this && (sourceCell = this.findCell(graph, caller.getCellKey())) != null) {
            double xTarget;
            double xSource;
            created = true;
            mxCell cell = this.findCell(graph, this.getCellKey());
            if (sourceCell.getParent().getGeometry().getX() < cell.getParent().getGeometry().getX()) {
                xSource = 1.0;
                xTarget = 0.0;
            } else {
                xSource = 0.0;
                xTarget = 1.0;
            }
            double y = (double)(this.getStartIndex() - caller.getStartIndex()) / (double)(caller.getEndIndex() - caller.getStartIndex());
            mxCell sourcePort = (mxCell)graph.insertVertex((Object)sourceCell, null, null, xSource, y, 0.0, 0.0);
            sourcePort.getGeometry().setRelative(true);
            mxCell targetPort = (mxCell)graph.insertVertex((Object)cell, null, null, xTarget, 0.0, 0.0, 0.0);
            targetPort.getGeometry().setRelative(true);
            graph.insertEdge(null, null, (Object)this.getCallMessage(), (Object)sourcePort, (Object)targetPort, "message");
            y = (double)(this.getEndIndex() - caller.getStartIndex()) / (double)(caller.getEndIndex() - caller.getStartIndex());
            sourcePort = (mxCell)graph.insertVertex((Object)cell, null, null, xTarget, 1.0, 0.0, 0.0);
            sourcePort.getGeometry().setRelative(true);
            targetPort = (mxCell)graph.insertVertex((Object)sourceCell, null, null, xSource, y, 0.0, 0.0);
            targetPort.getGeometry().setRelative(true);
            String style = this.getReturnMessage().hasError() ? "replyMessage;strokeColor=red" : "replyMessage";
            mxCell edge = (mxCell)graph.insertEdge(null, null, (Object)this.getReturnMessage(), (Object)sourcePort, (Object)targetPort, style);
            edge.getGeometry().setOffset(new mxPoint(0.0, -5.0));
        }
        for (ActivationBox box : this.getChildren()) {
            if (!(box instanceof CustomBox)) continue;
            box.createEdges(graph);
        }
        return created;
    }

    public String toString() {
        return this.duration == -1 ? "" : this.duration + "ms";
    }

    protected ActivationBox getCaller() {
        ActivationBox parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }
}

