/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.analyzer.gui.event.TransactionLogDiagramSelectionEvent;
import ch.e2e.builder.analyzer.gui.tree.Logging;
import ch.e2e.builder.analyzer.gui.tree.TransactionLogTreeModel;
import ch.e2e.builder.analyzer.gui.tree.TreeView;
import ch.e2e.builder.analyzer.gui.tree.menu.DeleteTransactionLogExecuter;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import ch.e2e.builder.analyzer.model.event.DeleteTransactionLogEvent;
import ch.e2e.builder.analyzer.tree.RefreshTransactionLogsTreeEvent;
import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.E2EBuilderFrame;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TransactionLogsTreeView
extends TreeView<TransactionLogsRoot>
implements TreeWillExpandListener,
TreeExpansionListener,
Logging {
    private TransactionLogTreeModel treeModel;

    public TransactionLogsTreeView(TransactionLogsRoot root, Analyzer analyzer) {
        super(root, analyzer);
    }

    @Override
    protected Tree createTree(TransactionLogsRoot root) {
        this.treeModel = new TransactionLogTreeModel(root, this.getAnalyzer());
        Tree tree = new Tree((AbstractTreeModel)this.treeModel);
        tree.addTreeWillExpandListener((TreeWillExpandListener)this);
        tree.addTreeExpansionListener((TreeExpansionListener)this);
        tree.setEditable(false);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setSelectWithPopupTrigger(false);
        tree.getSelectionModel().setSelectionMode(1);
        return tree;
    }

    @Override
    public void refreshTree(EventObject event) {
        TransactionLogObject parent = ((RefreshTransactionLogsTreeEvent)event).getNewSelection();
        if (parent == null) {
            this.setSelectionPath(null);
            this.getTree().refresh();
        } else {
            List expandedRows = this.getTree().getExpandedRows();
            this.getModel().refresh();
            ArrayList<TransactionLogObject> pathObjects = new ArrayList<TransactionLogObject>();
            while (parent != null) {
                pathObjects.add(0, parent);
                parent = parent.getParent();
            }
            TreePath path = new TreePath(pathObjects.toArray());
            for (TreePath p : expandedRows) {
                if (path.isDescendant(p)) continue;
                this.expandPath(p);
            }
            this.expandPath(path);
            this.setSelectionPath(path);
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Object component = event.getPath().getLastPathComponent();
        if (component instanceof TransactionLog) {
            TransactionLog transactionLog = (TransactionLog)component;
            this.setWaitCursor();
            if (!transactionLog.isLoaded()) {
                try {
                    transactionLog.load();
                    for (Throwable error : transactionLog.getErrors()) {
                        this.getAnalyzer().showError(error.getMessage());
                        logger.warning(error.getMessage());
                    }
                    this.setSelectionPath(event.getPath());
                }
                catch (Exception e) {
                    E2EBuilderInfoDialog.error((String)e.getMessage());
                    this.setDefaultCursor();
                    this.getAnalyzer().showError(e.toString());
                    logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    logger.throwing(this.getClass().getName(), "treeWillExpand", e);
                }
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.setDefaultCursor();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private void setDefaultCursor() {
        Frame applicationFrame = E2EBuilder.getInstance().getApplicationFrame();
        if (applicationFrame instanceof E2EBuilderFrame) {
            ((E2EBuilderFrame)applicationFrame).setDefaultCursor();
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setWaitCursor() {
        Frame applicationFrame = E2EBuilder.getInstance().getApplicationFrame();
        if (applicationFrame instanceof E2EBuilderFrame) {
            ((E2EBuilderFrame)applicationFrame).setWaitCursor();
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    protected void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){
            private HashMap<TransactionLogObject, HashMap<Integer, TreePath>> cache = new HashMap();

            public void execute(EventObject event) throws EventExecutionVetoException {
                int lineNumber;
                TransactionLogDiagramSelectionEvent e = (TransactionLogDiagramSelectionEvent)event;
                TransactionLogObject root = e.getRoot();
                TreePath path = this.getFromCache(root, lineNumber = e.getActivationBox().getStartLine());
                if (path == null) {
                    path = this.findPath(root, lineNumber);
                }
                TransactionLogsTreeView.this.getTree().setSelectionPath(path);
                TransactionLogsTreeView.this.getTree().scrollPathToVisible(path);
            }

            private TreePath getFromCache(TransactionLogObject root, Integer lineNumber) {
                HashMap<Integer, TreePath> map = this.cache.get(root);
                return map == null ? null : map.get(lineNumber);
            }

            private TreePath findPath(TransactionLogObject root, int lineNumber) {
                Iterator iterator = TransactionLogsTreeView.this.treeModel.depthFirstIterator(root);
                TreePath path = null;
                while (path == null && iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof TransactionLogEntry) || ((TransactionLogEntry)next).getLineNumber() != lineNumber) continue;
                    path = new TreePath(((TransactionLogEntry)next).getPath());
                    this.cache(root, lineNumber, path);
                }
                return path;
            }

            private void cache(TransactionLogObject root, Integer lineNumber, TreePath path) {
                HashMap<Integer, TreePath> map = this.cache.get(root);
                if (map == null) {
                    map = new HashMap();
                    this.cache.put(root, map);
                }
                map.put(lineNumber, path);
            }
        }, TransactionLogDiagramSelectionEvent.class);
        EventController.register((EventExecuter)new DeleteTransactionLogExecuter(this.getAnalyzer()), DeleteTransactionLogEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                TransactionLogsTreeView.this.refreshTree(event);
            }
        }, RefreshTransactionLogsTreeEvent.class);
    }
}

