/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import sun.swing.DefaultLookup;

public class RolloverListCellRenderer
implements ListCellRenderer {
    private final JList list;
    private final ListCellRenderer delegate;
    private final MouseAdapter mouseHandler;
    private int rolloverIndex = -1;

    public RolloverListCellRenderer(final JList list) {
        this.list = list;
        this.delegate = list.getCellRenderer();
        list.setCellRenderer(this);
        this.mouseHandler = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int mouseIndex = list.locationToIndex(e.getPoint());
                if (mouseIndex != RolloverListCellRenderer.this.rolloverIndex) {
                    Rectangle bounds = list.getCellBounds(RolloverListCellRenderer.this.rolloverIndex, RolloverListCellRenderer.this.rolloverIndex);
                    if (bounds != null) {
                        list.repaint(bounds);
                    }
                    if ((bounds = list.getCellBounds(mouseIndex, mouseIndex)) == null || !bounds.contains(e.getPoint())) {
                        RolloverListCellRenderer.this.rolloverIndex = -1;
                    } else {
                        RolloverListCellRenderer.this.rolloverIndex = mouseIndex;
                        list.repaint(bounds);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Rectangle bounds = list.getCellBounds(RolloverListCellRenderer.this.rolloverIndex, RolloverListCellRenderer.this.rolloverIndex);
                RolloverListCellRenderer.this.rolloverIndex = -1;
                if (bounds != null) {
                    list.repaint(bounds);
                }
            }
        };
        list.addMouseListener(this.mouseHandler);
        list.addMouseMotionListener(this.mouseHandler);
    }

    public void uninstall() {
        if (this.list.getCellRenderer() == this) {
            this.list.setCellRenderer(this.getDelegate());
        }
        this.list.removeMouseListener(this.mouseHandler);
        this.list.removeMouseMotionListener(this.mouseHandler);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent comp;
        if (list.getCellRenderer() == this) {
            comp = (JComponent)this.getDelegate().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (index == this.getRolloverIndex()) {
                ComponentUI ui = UIManager.getDefaults().getUI(comp);
                Border border = DefaultLookup.getBorder(comp, ui, "List.focusCellHighlightBorder");
                comp.setBorder(border);
            }
        } else {
            comp = (JComponent)list.getCellRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        return comp;
    }

    protected final int getRolloverIndex() {
        return this.rolloverIndex;
    }

    protected final ListCellRenderer getDelegate() {
        return this.delegate;
    }
}

