/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JRadioButton;

public class InputRadioButton
extends JRadioButton
implements InputField,
ItemListener {
    private InputFieldListener listener;

    public InputRadioButton() {
    }

    public InputRadioButton(String label) {
        this(label, false);
    }

    public InputRadioButton(String label, boolean state) {
        super(label, state);
        this.addItemListener(this);
    }

    @Override
    public Object getContent() {
        if (this.isSelected()) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    @Override
    public void setContent(Object content) {
        Boolean bool = (Boolean)content;
        if (bool.booleanValue()) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            InputFieldEvent e = new InputFieldEvent(this);
            this.listener.inputFieldChanged(e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireInputField();
    }

    @Override
    public void setEditable(boolean editable) {
        this.setEnabled(editable);
    }
}

