/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.print;

import ch.e2e.print.PrintTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JTable;

public class TablePrinter {
    public static Printable getPrintable(JTable table, MediaPrintableArea printableArea, OrientationRequested orientation) {
        return new PrintableTable(table, printableArea, orientation);
    }

    private static class PrintableTable
    implements Printable {
        private JTable table;
        private Color background;
        private Point[] points;
        private int headerHeight;

        private PrintableTable(JTable table, MediaPrintableArea printableArea, OrientationRequested orientation) {
            int pageHeight;
            int pageWidth;
            this.table = table;
            this.background = table.getBackground();
            Dimension tableSize = table.getBounds().getSize();
            this.headerHeight = table.getTableHeader().getSize().height;
            if (orientation.equals(OrientationRequested.PORTRAIT)) {
                pageWidth = (int)PrintTools.milimeter2Dots(printableArea.getWidth(1000));
                pageHeight = (int)PrintTools.milimeter2Dots(printableArea.getHeight(1000)) - this.headerHeight;
            } else {
                pageHeight = (int)PrintTools.milimeter2Dots(printableArea.getWidth(1000));
                pageWidth = (int)PrintTools.milimeter2Dots(printableArea.getHeight(1000)) - this.headerHeight;
            }
            int columns = tableSize.width / pageWidth;
            int rows = tableSize.height / pageHeight;
            int pageCount = (rows += tableSize.height % pageHeight > 0 ? 1 : 0) * (columns += tableSize.width % pageWidth > 0 ? 1 : 0);
            this.points = new Point[pageCount];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    int index = i * columns + j;
                    int x = j * pageWidth;
                    int y = i * pageHeight;
                    this.points[index] = new Point(x, y);
                }
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int result;
            if (pageIndex == this.points.length) {
                result = 1;
            } else {
                int translateX = (int)pageFormat.getImageableX();
                int translateY = (int)pageFormat.getImageableY();
                int width = (int)pageFormat.getImageableWidth();
                int height = (int)pageFormat.getImageableHeight();
                graphics.setClip(translateX, translateY, width, height);
                graphics.translate(translateX - this.points[pageIndex].x, translateY);
                this.table.getTableHeader().paint(graphics);
                graphics.translate(-(translateX - this.points[pageIndex].x), -translateY);
                graphics.setClip(translateX, translateY + this.headerHeight, width, height - this.headerHeight);
                graphics.translate(translateX - this.points[pageIndex].x, translateY - this.points[pageIndex].y + this.headerHeight);
                this.table.setBackground(Color.white);
                this.table.paint(graphics);
                this.table.setBackground(this.background);
                result = 0;
            }
            return result;
        }
    }
}

