/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.dom4j.DOM4JNodeWrapper;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class DOM4JDocumentWrapper
extends GenericTreeInfo {
    public DOM4JDocumentWrapper(Document doc, String baseURI, Configuration config) {
        super(config);
        this.setRootNode(this.wrap((Node)doc));
        this.setSystemId(baseURI);
    }

    public NodeInfo wrap(Node node) {
        return DOM4JNodeWrapper.makeWrapper(node, this);
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        HashMap idIndex = (HashMap)this.getUserData("saxon-id-index");
        if (idIndex != null) {
            Element e = (Element)idIndex.get(id);
            return e == null ? null : this.wrap((Node)e);
        }
        return null;
    }

    public static Branch searchForParent(Branch subtree, Node node) {
        List content = subtree.content();
        for (Object o : content) {
            Branch b;
            Node child = (Node)o;
            if (child == node) {
                return subtree;
            }
            if (!child.hasContent() || (b = DOM4JDocumentWrapper.searchForParent((Branch)child, node)) == null) continue;
            return b;
        }
        return null;
    }
}

